/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.util;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.model.log.LogModel;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.MyCrypto;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.keyoperator.KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ConfidentialUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionModel encrypt(TransactionModel requestTransaction, byte[] encryptionKey, List<byte[]> envelopeSealKeys) {
        AlgoIdEnum algoId;
        TransactionModel confidentialTransaction = new TransactionModel().setTxType(TransactionType.TX_CONFIDENTIAL).setHash(requestTransaction.getHash()).setTimestamp(requestTransaction.getTimestamp()).setNonce(requestTransaction.getNonce());
        if (envelopeSealKeys == null || envelopeSealKeys.isEmpty()) throw new RuntimeException("seal public keys cannot be empty");
        KeyOperator keyOperator = MyCrypto.getInstance().getKeyOperator(KeyTypeEnum.KEY_ECCK1_PKCS8);
        Keypair keypair = keyOperator.loadFromPubkey(envelopeSealKeys.get(0));
        if (keypair.getType() == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_SGX;
        } else if (keypair.getType() == KeyTypeEnum.KEY_RSA2048_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_RSA_LOCAL_SGX;
        } else {
            if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) throw new RuntimeException(String.format("unsupported algorithm encryption algorithm %s", keypair.getType().name()));
            algoId = AlgoIdEnum.ENVELOPE_SM2_LOCAL_SGX;
        }
        EnvelopeBase envelopeBase = MyCrypto.getInstance().createEnvelopeByAlgo(algoId);
        ArrayList<Keypair> keyPairs = new ArrayList<Keypair>();
        for (byte[] publicKey : envelopeSealKeys) {
            Keypair keyPair = new Keypair(publicKey);
            keyPairs.add(keyPair);
        }
        envelopeBase.setPubkeyList(keyPairs);
        byte[] cipherText = envelopeBase.envelopeSeal(requestTransaction.toRlp(), encryptionKey);
        confidentialTransaction.setData(cipherText);
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        bytes.add(ByteUtils.hexStringToBytes((String)"FF"));
        confidentialTransaction.setSignatureList(bytes);
        return confidentialTransaction;
    }

    public static TransactionModel decryptTransaction(TransactionModel encryptedTx, KeyTypeEnum sealPubKeyType, String rootKey) {
        AlgoIdEnum algoId;
        if (!TransactionType.TX_CONFIDENTIAL.equals((Object)encryptedTx.getTxType())) {
            return encryptedTx;
        }
        if (sealPubKeyType == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_SGX;
        } else if (sealPubKeyType == KeyTypeEnum.KEY_RSA2048_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_RSA_LOCAL_SGX;
        } else if (sealPubKeyType == KeyTypeEnum.KEY_SM2_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_SM2_LOCAL_SGX;
        } else {
            throw new RuntimeException(String.format("unsupported algorithm encryption algorithm %s", sealPubKeyType.name()));
        }
        EnvelopeBase envelopeBase = MyCrypto.getInstance().createEnvelopeByAlgo(algoId);
        byte[] plainText = envelopeBase.envelopeOpen(encryptedTx.getData(), com.alipay.mychain.sdk.api.utils.ConfidentialUtil.keyGenerate((String)rootKey, (byte[])encryptedTx.getHash().getData()));
        RlpList rlpData = Rlp.decode2((byte[])plainText);
        return new TransactionModel().fromRlp((RlpList)rlpData.get(0));
    }

    public static ReceiptModel decryptReceipt(ReceiptModel receiptModel, byte[] transactionKey) {
        if (transactionKey == null) {
            return receiptModel;
        }
        ReceiptModel receiptCopy = new ReceiptModel().setBlockNumber(new BigInteger(receiptModel.getBlockNumber().toByteArray())).setGasUsed(new BigInteger(receiptModel.getGasUsed().toByteArray())).setResult(receiptModel.getResult()).setTxHash(new Hash(receiptModel.getTxHash())).setTxIndex(receiptModel.getTxIndex());
        try {
            AesGcmCipherV1 aesGcmCipherV1 = new AesGcmCipherV1(transactionKey);
            byte[] algoId = AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1.toBytes();
            if (ArrayUtils.isNotEmpty((byte[])receiptModel.getOutput()) && receiptModel.getOutput().length >= 28) {
                byte[] ciphertext = new byte[receiptModel.getOutput().length + 2];
                System.arraycopy(algoId, 0, ciphertext, 0, 2);
                System.arraycopy(receiptModel.getOutput(), receiptModel.getOutput().length - 28, ciphertext, 2, 28);
                System.arraycopy(receiptModel.getOutput(), 0, ciphertext, 30, receiptModel.getOutput().length - 28);
                byte[] output = aesGcmCipherV1.decrypt(ciphertext);
                receiptCopy.setOutput(output);
            } else {
                receiptCopy.setOutput(receiptModel.getOutput());
            }
            if (receiptModel.getLogs() != null) {
                receiptCopy.setLogs(new ArrayList<LogModel>());
                for (LogModel logEntry : receiptModel.getLogs()) {
                    LogModel logCopy = logEntry.copy();
                    if (ArrayUtils.isEmpty((byte[])logCopy.getLogData()) || logCopy.getLogData().length < 28) {
                        receiptCopy.getLogs().add(logCopy);
                        continue;
                    }
                    byte[] ciphertext = new byte[logCopy.getLogData().length + 2];
                    System.arraycopy(algoId, 0, ciphertext, 0, 2);
                    System.arraycopy(logCopy.getLogData(), logCopy.getLogData().length - 28, ciphertext, 2, 28);
                    System.arraycopy(logCopy.getLogData(), 0, ciphertext, 30, logCopy.getLogData().length - 28);
                    byte[] data = aesGcmCipherV1.decrypt(ciphertext);
                    logCopy.setLogData(data);
                    receiptCopy.getLogs().add(logCopy);
                }
            }
        }
        catch (Throwable e) {
            return receiptModel;
        }
        return receiptCopy;
    }

    public static ReceiptModel decryptReceipt(ReceiptModel receiptModel, String rootKey) {
        if (StringUtils.isEmpty((String)rootKey)) {
            throw new RuntimeException("decryption key is empty");
        }
        return ConfidentialUtil.decryptReceipt(receiptModel, receiptModel.getTxHash(), rootKey);
    }

    public static ReceiptModel decryptReceipt(ReceiptModel receiptModel, Hash txHash, String rootKey) {
        if (receiptModel.getTxHash() == null || receiptModel.getTxHash().isEmpty()) {
            throw new RuntimeException("receipt does not have tx hash");
        }
        return ConfidentialUtil.decryptReceipt(receiptModel, com.alipay.mychain.sdk.api.utils.ConfidentialUtil.keyGenerate((String)rootKey, (byte[])txHash.getData()));
    }
}

