/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.util;

import com.alipay.chainstack.commons.utils.ResourceUtils;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.key.ECCK1Key;
import com.alipay.chainstack.jbcc.mychainx.domain.key.ECCR1Key;
import com.alipay.chainstack.jbcc.mychainx.domain.key.Key;
import com.alipay.chainstack.jbcc.mychainx.domain.key.RSAKey;
import com.alipay.chainstack.jbcc.mychainx.domain.key.SM2Key;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Hex;

public abstract class KeyUtils {
    private static final String ROOT_PATH_PREFIX = "/";

    public static Key loadKey(String keyPath, String password) {
        try {
            return KeyUtils.loadKey(ResourceUtils.getInputStream((String)keyPath, null), password);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed to load key from file %s", keyPath), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key loadKey(File file, String password) {
        try (FileInputStream keyStream = new FileInputStream(file);){
            Key key = KeyUtils.loadKey(keyStream, password);
            return key;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("failed to load key from file %s", file.getAbsolutePath()), e);
        }
    }

    public static Key loadKey(InputStream keyStream, String password) throws IOException {
        return KeyUtils.loadKey(IOUtils.toByteArray((InputStream)keyStream), password);
    }

    public static Key loadKey(byte[] keyBytes, String password) {
        Pkcs8KeyOperator pkcs8KeyOperator = new Pkcs8KeyOperator();
        if (StringUtils.isEmpty((String)password)) {
            try {
                return KeyUtils.getKeyFromKeypair(pkcs8KeyOperator.loadFromPrivkey(keyBytes));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return KeyUtils.getKeyFromKeypair(pkcs8KeyOperator.load(keyBytes, password));
    }

    public static Key getKeyFromKeypair(Keypair keypair) {
        switch (keypair.getType()) {
            case KEY_ECCK1_PKCS8: {
                return new ECCK1Key(keypair);
            }
            case KEY_SM2_PKCS8: {
                return new SM2Key(keypair);
            }
            case KEY_RSA2048_PKCS8: {
                return new RSAKey(keypair);
            }
            case KEY_ECCR1_PKCS8: {
                return new ECCR1Key(keypair);
            }
        }
        throw new RuntimeException(String.format("unsupported key type %s", keypair.getType()));
    }

    public static List<byte[]> loadPubKeyList(List<String> publicKeyPaths) {
        ArrayList<byte[]> publicHexBytes = new ArrayList<byte[]>();
        if (publicKeyPaths != null) {
            for (String envelopeSealKeyPath : publicKeyPaths) {
                if (StringUtils.isEmpty((String)envelopeSealKeyPath)) continue;
                publicHexBytes.add(KeyUtils.loadPublicKey(ResourceUtils.readResourceBytes((String)envelopeSealKeyPath)));
            }
        }
        return publicHexBytes;
    }

    public static byte[] loadPublicKey(String publicKeyPath) {
        return KeyUtils.loadPublicKey(ResourceUtils.readResourceBytes((String)publicKeyPath));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] loadPublicKey(byte[] publicKeyContent) {
        if (publicKeyContent == null || publicKeyContent.length <= 0) {
            throw new RuntimeException("public key content is empty");
        }
        Keypair pubKey = null;
        try {
            pubKey = new Pkcs8KeyOperator().loadPubkey(publicKeyContent);
            if (pubKey != null) return pubKey.getPubkeyEncoded();
        }
        catch (Exception e) {
            try {
                pubKey = new Pkcs8KeyOperator().loadFromPubkey(Hex.decode((byte[])publicKeyContent));
                if (pubKey != null) return pubKey.getPubkeyEncoded();
            }
            catch (Throwable throwable) {
                if (pubKey != null) throw throwable;
                throw new RuntimeException(String.format("unable to load public key from content %s", Hex.toHexString((byte[])publicKeyContent)));
            }
            throw new RuntimeException(String.format("unable to load public key from content %s", Hex.toHexString((byte[])publicKeyContent)));
        }
        throw new RuntimeException(String.format("unable to load public key from content %s", Hex.toHexString((byte[])publicKeyContent)));
    }
}

