/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.util;

import com.alipay.chainstack.commons.utils.ReflectionUtil;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.account.NamedIdentity;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.RequestContext;
import com.alipay.chainstack.jbcc.mychainx.model.response.ResponseContext;
import java.math.BigInteger;

public abstract class VOUtils {
    public static final String REQ_CONTEXT_FIELD = "reqContext";
    public static final String REQ_CONTEXT_ACCOUNT_FIELD = "accountHexId";
    public static final String REQ_CONTEXT_ACCOUNT_NAME_FIELD = "accountName";
    public static final String REQ_CONTEXT_CONTRACT_FIELD = "contractHexId";
    public static final String REQ_CONTEXT_CONTRACT_NAME_FIELD = "contractName";
    public static final String REQ_CONTEXT_BLOCK_NUMBER_FIELD = "blockNumber";
    public static final String REQ_CONTEXT_LOCAL_CALL_FIELD = "localCall";
    public static final String RESP_CONTEXT_FIELD = "respContext";
    public static final String RESP_CONTEXT_SUCCESS_FIELD = "success";
    public static final String RESP_CONTEXT_TX_HASH_FIELD = "txHash";
    public static final String RESP_CONTEXT_TX_INDEX_FIELD = "txIndex";
    public static final String RESP_CONTEXT_BLOCK_NUMBER_FIELD = "blockNumber";
    public static final String RESP_CONTEXT_RESULT_CODE_FIELD = "resultCode";
    public static final String RESP_CONTEXT_ERROR_MSG_FIELD = "errorMsg";

    public static void copyRequestContext(Object fromVO, RequestContext toRequestContext) {
        if (fromVO == null || toRequestContext == null) {
            return;
        }
        try {
            Object result = ReflectionUtil.getPropertyWithFallback((Object)fromVO, (String)REQ_CONTEXT_FIELD);
            String accountName = (String)ReflectionUtil.getPropertyWithFallback((Object)result, (String)REQ_CONTEXT_ACCOUNT_NAME_FIELD);
            if (StringUtils.isEmpty((String)accountName)) {
                String accountHexId = (String)ReflectionUtil.getPropertyWithFallback((Object)result, (String)REQ_CONTEXT_ACCOUNT_FIELD);
                if (!StringUtils.isEmpty((String)accountHexId)) {
                    toRequestContext.setAccount(new Identity(accountHexId));
                }
            } else {
                toRequestContext.setAccount(new NamedIdentity(accountName));
            }
            String contractName = (String)ReflectionUtil.getPropertyWithFallback((Object)result, (String)REQ_CONTEXT_CONTRACT_NAME_FIELD);
            if (StringUtils.isEmpty((String)contractName)) {
                String contractHexId = (String)ReflectionUtil.getPropertyWithFallback((Object)result, (String)REQ_CONTEXT_CONTRACT_FIELD);
                if (!StringUtils.isEmpty((String)contractHexId)) {
                    toRequestContext.setContractNameHex(contractHexId);
                }
            } else {
                toRequestContext.setContractName(contractName);
            }
            Boolean localCall = (Boolean)ReflectionUtil.getPropertyWithFallback((Object)result, (String)REQ_CONTEXT_LOCAL_CALL_FIELD);
            toRequestContext.setLocalCall(localCall != null && localCall != false);
            toRequestContext.setBlockNumber((BigInteger)ReflectionUtil.getPropertyWithFallback((Object)result, (String)"blockNumber"));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to copy request context from vo to bao request", e);
        }
    }

    public static void copyResponseContext(ResponseContext fromResponseContext, Object toVO) {
        if (fromResponseContext == null || toVO == null) {
            return;
        }
        try {
            Object respContext = ReflectionUtil.getPropertyWithFallback((Object)toVO, (String)RESP_CONTEXT_FIELD);
            if (respContext == null) {
                return;
            }
            ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)RESP_CONTEXT_SUCCESS_FIELD, (Object)fromResponseContext.isSuccess());
            ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)RESP_CONTEXT_RESULT_CODE_FIELD, (Object)fromResponseContext.getResultCode());
            ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)RESP_CONTEXT_ERROR_MSG_FIELD, (Object)fromResponseContext.getErrorMsg());
            ReceiptModel receipt = fromResponseContext.getReceiptModel();
            if (receipt != null) {
                ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)"blockNumber", (Object)receipt.getBlockNumber());
                ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)RESP_CONTEXT_TX_INDEX_FIELD, (Object)receipt.getTxIndex());
                ReflectionUtil.setPropertyWithFallback((Object)respContext, (String)RESP_CONTEXT_TX_HASH_FIELD, receipt.getTxHash() == null ? null : receipt.getTxHash().hexStrValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unable to copy bao response context to vo", e);
        }
    }
}

