/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.sd;

import com.authlete.sd.Disclosure;
import com.authlete.sd.SDConstants;
import com.authlete.sd.SDObjectBuilder;
import com.authlete.sd.SDUtility;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class SDObjectEncoder {
    private static final double DECOY_MAGNIFICATION_MIN_LIMIT = 0.0;
    private static final double DECOY_MAGNIFICATION_MAX_LIMIT = 10.0;
    private static final double DECOY_MAGNIFICATION_MIN_DEFAULT = 0.5;
    private static final double DECOY_MAGNIFICATION_MAX_DEFAULT = 1.5;
    private final Random random = new SecureRandom();
    private String hashAlgorithm;
    private double decoyMagnificationMin;
    private double decoyMagnificationMax;
    private boolean hashAlgorithmIncluded;
    private final Set<String> retainedClaims;
    private List<Disclosure> disclosures;

    public SDObjectEncoder() {
        this("sha-256", 0.5, 1.5);
    }

    public SDObjectEncoder(String hashAlgorithm) {
        this(hashAlgorithm, 0.5, 1.5);
    }

    public SDObjectEncoder(double decoyMagnificationMin, double decoyMagnificationMax) {
        this("sha-256", decoyMagnificationMin, decoyMagnificationMax);
    }

    public SDObjectEncoder(String hashAlgorithm, double decoyMagnificationMin, double decoyMagnificationMax) {
        if (decoyMagnificationMin > decoyMagnificationMax) {
            throw new IllegalArgumentException("decoyMagnificationMin > decoyMagnificationMax");
        }
        this.hashAlgorithm = SDObjectEncoder.normalizeHashAlgorithm(hashAlgorithm);
        this.decoyMagnificationMin = SDObjectEncoder.normalizeDecoyMagnification(decoyMagnificationMin);
        this.decoyMagnificationMax = SDObjectEncoder.normalizeDecoyMagnification(decoyMagnificationMax);
        this.hashAlgorithmIncluded = true;
        this.retainedClaims = new TreeSet<String>(SDConstants.RETAINED_CLAIMS);
    }

    private static String normalizeHashAlgorithm(String hashAlgorithm) {
        return hashAlgorithm != null ? hashAlgorithm : "sha-256";
    }

    private static double normalizeDecoyMagnification(double magnification) {
        return SDObjectEncoder.between(0.0, magnification, 10.0);
    }

    private static double between(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public SDObjectEncoder setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = SDObjectEncoder.normalizeHashAlgorithm(hashAlgorithm);
        return this;
    }

    public SDObjectEncoder setDecoyMagnification(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        this.decoyMagnificationMin = SDObjectEncoder.normalizeDecoyMagnification(min);
        this.decoyMagnificationMax = SDObjectEncoder.normalizeDecoyMagnification(max);
        return this;
    }

    public boolean isHashAlgorithmIncluded() {
        return this.hashAlgorithmIncluded;
    }

    public SDObjectEncoder setHashAlgorithmIncluded(boolean included) {
        this.hashAlgorithmIncluded = included;
        return this;
    }

    public Set<String> getRetainedClaims() {
        return this.retainedClaims;
    }

    public List<Disclosure> getDisclosures() {
        return this.disclosures;
    }

    public Map<String, Object> encode(Map<String, Object> input) {
        this.reset();
        if (input == null) {
            return null;
        }
        return this.encodeMap(input, true);
    }

    public List<Object> encode(List<?> input) {
        this.reset();
        if (input == null) {
            return null;
        }
        return this.encodeList(input);
    }

    private void reset() {
        this.disclosures = new ArrayList<Disclosure>();
    }

    private Map<String, Object> encodeMap(Map<String, Object> input) {
        return this.encodeMap(input, false);
    }

    private Map<String, Object> encodeMap(Map<String, Object> input, boolean top) {
        SDObjectBuilder builder = new SDObjectBuilder(this.getHashAlgorithm());
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (top && this.retainedClaims.contains(key)) {
                builder.putClaim(key, value);
                continue;
            }
            if (value instanceof Map) {
                value = this.encodeMap((Map)value);
                builder.putClaim(key, value);
                continue;
            }
            if (value instanceof List) {
                value = this.encodeList((List)value);
                builder.putClaim(key, value);
                continue;
            }
            Disclosure disclosure = builder.putSDClaim(key, value);
            this.disclosures.add(disclosure);
        }
        int decoyCount = this.computeDecoyCount(input.size());
        builder.putDecoyDigests(decoyCount);
        return builder.build(top && this.hashAlgorithmIncluded);
    }

    private List<Object> encodeList(List<?> input) {
        int inputSize = input.size();
        int decoyCount = this.computeDecoyCount(inputSize);
        ArrayList<Object> encodedList = new ArrayList<Object>(inputSize + decoyCount);
        for (Object value : input) {
            if (value instanceof Map) {
                value = this.encodeMap((Map)value);
            } else if (value instanceof List) {
                value = this.encodeList((List)value);
            } else {
                Disclosure disclosure = new Disclosure(value);
                this.disclosures.add(disclosure);
                value = disclosure.toArrayElement(this.getHashAlgorithm());
            }
            encodedList.add(value);
        }
        for (int i = 0; i < decoyCount; ++i) {
            int bound = encodedList.size() + 1;
            int index = this.random.nextInt(bound);
            encodedList.add(index, this.generateDecoyArrayElement());
        }
        return encodedList;
    }

    private int computeDecoyCount(int baseCount) {
        double min = this.decoyMagnificationMin;
        double max = this.decoyMagnificationMax;
        double d = min == max ? min : this.random.doubles(1L, min, max).findFirst().getAsDouble();
        return (int)Math.round((double)baseCount * d);
    }

    private Map<String, Object> generateDecoyArrayElement() {
        return SDUtility.generateDecoyArrayElement(this.getHashAlgorithm());
    }
}

