/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.entity;

import cn.org.atool.fluent.mybatis.processor.entity.FieldOrMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.util.GeneratorHelper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityRefMethod
extends FieldOrMethod {
    private final Map<String, String> mapping = new HashMap<String, String>();

    public EntityRefMethod(String property, TypeName javaType) {
        super(property, javaType);
    }

    public void setValue(String value) {
        String[] pairs;
        for (String pair : pairs = value.split("&")) {
            if (GeneratorHelper.isBlank((String)pair)) continue;
            if (RelationConfig.isEquation((String)pair)) {
                String[] items = pair.split("=");
                this.mapping.put(items[0].trim(), items[1].trim());
                continue;
            }
            this.mapping.clear();
            return;
        }
    }

    public String getRefMethod(FluentEntity fluent) {
        return MybatisUtil.methodNameOfEntity((String)this.name, (String)fluent.getClassName());
    }

    public boolean isAutoMapping() {
        return !this.mapping.isEmpty();
    }

    public String getReturnEntity() {
        List args;
        if (this.javaType instanceof ClassName) {
            return ((ClassName)this.javaType).simpleName();
        }
        if (this.javaType instanceof ParameterizedTypeName && (args = ((ParameterizedTypeName)this.javaType).typeArguments).size() == 1 && args.get(0) instanceof ClassName) {
            return ((ClassName)args.get(0)).simpleName();
        }
        throw new RuntimeException("not support the type[" + this.javaType.toString() + "], only support return: Entity or List<Entity>.");
    }

    public boolean returnList() {
        if (this.javaType instanceof ParameterizedTypeName) {
            ClassName type = ((ParameterizedTypeName)this.javaType).rawType;
            return List.class.getSimpleName().equals(type.simpleName());
        }
        return false;
    }

    public boolean isAbstractMethod() {
        if (!this.isAutoMapping()) {
            return true;
        }
        FluentEntity ref = FluentList.getFluentEntity(this.getReturnEntity());
        return ref == null;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    @Override
    public String toString() {
        return "EntityRefMethod(mapping=" + this.getMapping() + ")";
    }
}

