/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.entity;

import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.RefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.RelationFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.BaseDaoFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.EntityMappingFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.MapperFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.QueryFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.SegmentFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.UpdaterFiler;
import cn.org.atool.generator.javafile.AbstractFile;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.processing.Filer;

public class FluentList {
    private static final Map<String, List<FluentEntity>> fluents = new HashMap<String, List<FluentEntity>>();
    private static final Map<String, FluentEntity> map = new HashMap<String, FluentEntity>();

    public static void addFluent(FluentEntity fluent) {
        map.put(fluent.getClassName(), fluent);
        String _package = fluent.getBasePack();
        if (!fluents.containsKey(_package)) {
            fluents.put(_package, new ArrayList());
        }
        fluents.get(_package).add(fluent);
    }

    public static FluentEntity getFluentEntity(String entityName) {
        return map.get(entityName);
    }

    public static void generate(Filer filer, Consumer<String> logger) {
        for (Map.Entry<String, List<FluentEntity>> entry : fluents.entrySet()) {
            String basePackage = entry.getKey();
            List<FluentEntity> fluents = entry.getValue();
            fluents.sort(Comparator.comparing(FluentEntity::getNoSuffix));
            for (FluentEntity fluent : fluents) {
                FluentList.generate(filer, logger, fluent);
            }
            for (AbstractFile file : FluentList.refFiles(basePackage, fluents)) {
                FluentList.generateRef(filer, logger, file);
            }
        }
    }

    private static void generateRef(Filer filer, Consumer<String> logger, AbstractFile file) {
        try {
            file.writeTo(filer);
        }
        catch (Exception e) {
            logger.accept("Generate Refs error:\n" + GeneratorHelper.toString((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private static void generate(Filer filer, Consumer<String> logger, FluentEntity fluent) {
        try {
            List<AbstractFiler> javaFiles = FluentList.generateJavaFile(fluent);
            for (AbstractFiler javaFile : javaFiles) {
                javaFile.javaFile().writeTo(filer);
            }
        }
        catch (Exception e) {
            logger.accept("FluentEntityInfo:" + fluent + "\n" + GeneratorHelper.toString((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private static List<AbstractFile> refFiles(String _package, List<FluentEntity> fluents) {
        return Arrays.asList(new AbstractFile[]{new RelationFiler(_package, fluents), new RefFiler(_package, fluents)});
    }

    private static List<AbstractFiler> generateJavaFile(FluentEntity fluent) {
        return Arrays.asList(new MapperFiler(fluent), new EntityMappingFiler(fluent), new SegmentFiler(fluent), new QueryFiler(fluent), new UpdaterFiler(fluent), new BaseDaoFiler(fluent));
    }
}

