/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.refs;

import cn.org.atool.fluent.mybatis.base.intf.IRelation;
import cn.org.atool.fluent.mybatis.processor.entity.EntityRefMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.processor.filer.FilerKit;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import cn.org.atool.generator.javafile.AbstractFile;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RelationFiler
extends AbstractFile {
    private static final String EntityRelation = "IEntityRelation";
    private final List<FluentEntity> fluents;

    public RelationFiler(String basePackage, List<FluentEntity> fluents) {
        this.packageName = basePackage;
        this.fluents = fluents;
        this.klassName = EntityRelation;
        this.comment = "\u5b9e\u4f53\u7c7b\u95f4\u81ea\u5b9a\u4e49\u7684\u5173\u8054\u5173\u7cfb\u63a5\u53e3";
    }

    protected void staticImport(JavaFile.Builder builder) {
        builder.addStaticImport(RefKit.class, new String[]{"put"});
        builder.skipJavaLangImports(true);
    }

    protected void build(TypeSpec.Builder spec) {
        spec.addSuperinterface(IRelation.class);
        for (FluentEntity fluent : this.fluents) {
            for (EntityRefMethod method : fluent.getRefMethods()) {
                spec.addMethod(this.buildMethod(fluent, method));
            }
        }
        spec.addMethod(this.m_initialize());
    }

    private MethodSpec buildMethod(FluentEntity fluent, EntityRefMethod method) {
        if (method.isAbstractMethod()) {
            return this.m_abstractMethod(fluent, method);
        }
        return this.m_defaultMethod(fluent, method);
    }

    private MethodSpec m_abstractMethod(FluentEntity fluent, EntityRefMethod refField) {
        return MethodSpec.methodBuilder((String)refField.getRefMethod(fluent)).addParameter((TypeName)fluent.entity(), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(refField.getJavaType()).addJavadoc("{@link $L#$L()}", new Object[]{fluent.getClassName(), refField.getName()}).build();
    }

    private MethodSpec m_defaultMethod(FluentEntity fluent, EntityRefMethod refMethod) {
        FluentEntity ref = FluentList.getFluentEntity(refMethod.getReturnEntity());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)refMethod.getRefMethod(fluent)).addParameter((TypeName)fluent.entity(), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns(refMethod.getJavaType()).addJavadoc("{@link $L#$L()}", new Object[]{fluent.getClassName(), refMethod.getName()});
        String method = refMethod.returnList() ? ".to().listEntity()" : ".to().findOne().orElse(null)";
        spec.addCode("return new $T()\n", new Object[]{ref.query()});
        int index = 0;
        for (Map.Entry<String, String> pair : refMethod.getMapping().entrySet()) {
            spec.addCode(index == 0 ? "\t.where" : "\t.and", new Object[0]).addCode(".$L().eq(entity.get$L())\n", new Object[]{pair.getKey(), MybatisUtil.capitalFirst((String)pair.getValue(), (String)"")});
            ++index;
        }
        spec.addCode("\t.end()\n", new Object[]{method});
        spec.addStatement("\t" + method, new Object[0]);
        return spec.build();
    }

    private MethodSpec m_initialize() {
        MethodSpec.Builder spec = FilerKit.publicMethod("initialize", (TypeName)null).addModifiers(new Modifier[]{Modifier.DEFAULT});
        ArrayList<CodeBlock> codes = new ArrayList<CodeBlock>();
        for (FluentEntity fluent : this.fluents) {
            for (EntityRefMethod method : fluent.getRefMethods()) {
                codes.add(CodeBlock.of((String)"put(this::$L);", (Object[])new Object[]{method.getRefMethod(fluent)}));
            }
        }
        spec.addCode(CodeBlock.join(codes, (String)"\n"));
        return spec.build();
    }

    protected boolean isInterface() {
        return true;
    }
}

