/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.segment;

import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.IAggregate;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.FilerKit;
import cn.org.atool.fluent.mybatis.processor.filer.segment.FormSetterFiler;
import cn.org.atool.fluent.mybatis.segment.GroupByBase;
import cn.org.atool.fluent.mybatis.segment.HavingBase;
import cn.org.atool.fluent.mybatis.segment.HavingOperator;
import cn.org.atool.fluent.mybatis.segment.OrderByApply;
import cn.org.atool.fluent.mybatis.segment.OrderByBase;
import cn.org.atool.fluent.mybatis.segment.SelectorBase;
import cn.org.atool.fluent.mybatis.segment.UpdateApply;
import cn.org.atool.fluent.mybatis.segment.UpdateBase;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.where.BooleanWhere;
import cn.org.atool.fluent.mybatis.segment.where.NumericWhere;
import cn.org.atool.fluent.mybatis.segment.where.ObjectWhere;
import cn.org.atool.fluent.mybatis.segment.where.StringWhere;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;

public class SegmentFiler
extends AbstractFiler {
    static List<String> CONFLICT_AGGREGATE = Arrays.asList("origin", "aggregate", "max", "min", "sum", "avg", "count", "group_concat");
    static List<String> CONFLICT_SEGMENT = Arrays.asList("and", "or", "wrapper", "current", "apply");

    public SegmentFiler(FluentEntity fluent) {
        super(fluent);
        this.packageName = SegmentFiler.getPackageName(fluent);
        this.klassName = SegmentFiler.getClassName(fluent);
    }

    public static String getClassName(FluentClassName fluent) {
        return fluent.getNoSuffix() + "Segment";
    }

    public static String getPackageName(FluentClassName fluent) {
        return fluent.getPackageName("helper");
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        spec.addStaticImport(MybatisUtil.class, new String[]{"assertNotNull"});
        spec.addStaticImport(this.fluent.entityMapping(), new String[]{"*"});
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addAnnotation(FilerKit.suppressWarnings("unused", "rawtypes", "unchecked"));
        spec.addType(this.nestedISegment()).addType(this.nestedSelector()).addType(this.nestedEntityWhere()).addType(this.nestedQueryWhere()).addType(this.nestedUpdateWhere()).addType(this.nestedGroupBy()).addType(this.nestedHaving()).addType(this.nestedQueryOrderBy()).addType(this.nestedUpdateOrderBy()).addType(this.nestedUpdateSetter()).addType(this.nestedFormSetter());
    }

    private TypeSpec nestedFormSetter() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"FormSetter").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        new FormSetterFiler(this.fluent).build(builder);
        return builder.build();
    }

    private TypeSpec nestedISegment() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"ASegment").addTypeVariable(TypeVariableName.get((String)"R")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addMethod(this.m_set_ISegment());
        for (CommonField fc : this.fluent.getFields()) {
            builder.addMethod(MethodSpec.methodBuilder((String)fc.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)TypeVariableName.get((String)"R")).addStatement("return this.set($L)", new Object[]{fc.getName()}).build());
        }
        return builder.build();
    }

    private TypeSpec nestedGroupBy() {
        return TypeSpec.classBuilder((String)"GroupBy").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(GroupByBase.class), this.fluent.groupBy(), this.fluent.query())).addSuperinterface(super.paraType(this.fluent.segment(), this.fluent.groupBy())).addJavadoc("\u5206\u7ec4\u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1()).build();
    }

    private TypeSpec nestedHaving() {
        return TypeSpec.classBuilder((String)"Having").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(HavingBase.class), this.fluent.having(), this.fluent.query())).addSuperinterface(super.paraType(this.fluent.segment(), super.paraType(ClassName.get(HavingOperator.class), this.fluent.having()))).addJavadoc("\u5206\u7ec4Having\u6761\u4ef6\u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1()).addMethod(this.constructor2_Having()).addMethod(this.m_aggregate_Having()).build();
    }

    private TypeSpec nestedQueryOrderBy() {
        return TypeSpec.classBuilder((String)"QueryOrderBy").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(OrderByBase.class), this.fluent.queryOrderBy(), this.fluent.query())).addSuperinterface(super.paraType(this.fluent.segment(), super.paraType(ClassName.get(OrderByApply.class), this.fluent.queryOrderBy(), this.fluent.query()))).addJavadoc("Query OrderBy\u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1()).build();
    }

    private TypeSpec nestedUpdateOrderBy() {
        return TypeSpec.classBuilder((String)"UpdateOrderBy").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(OrderByBase.class), this.fluent.updateOrderBy(), this.fluent.updater())).addSuperinterface(super.paraType(this.fluent.segment(), super.paraType(ClassName.get(OrderByApply.class), this.fluent.updateOrderBy(), this.fluent.updater()))).addJavadoc("Update OrderBy\u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1_Update()).build();
    }

    private TypeSpec nestedUpdateSetter() {
        return TypeSpec.classBuilder((String)"UpdateSetter").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(UpdateBase.class), this.fluent.updateSetter(), this.fluent.updater())).addSuperinterface(super.paraType(this.fluent.segment(), super.paraType(ClassName.get(UpdateApply.class), this.fluent.updateSetter(), this.fluent.updater()))).addJavadoc("Update set \u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1_Update()).build();
    }

    private TypeSpec nestedSelector() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Selector").addModifiers(FilerKit.PUBLIC_STATIC_FINAL).superclass(super.paraType(ClassName.get(SelectorBase.class), this.fluent.selector(), this.fluent.query())).addSuperinterface(super.paraType(this.fluent.segment(), this.fluent.selector())).addJavadoc("select\u5b57\u6bb5\u8bbe\u7f6e", new Object[0]).addMethod(this.constructor1()).addMethod(this.constructor2_Selector()).addMethod(this.m_aggregate_Selector());
        for (CommonField fc : this.fluent.getFields()) {
            builder.addMethod(MethodSpec.methodBuilder((String)fc.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "_alias_", new Modifier[0]).returns((TypeName)this.fluent.selector()).addStatement("return this.process($L, _alias_)", new Object[]{this.varAggregate(fc.getName())}).build());
        }
        return builder.build();
    }

    private TypeSpec nestedEntityWhere() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"EntityWhere").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.ABSTRACT}).addTypeVariable(TypeVariableName.get((String)"W", (TypeName[])new TypeName[]{this.paraType(WhereBase.class, "W", "U", this.fluent.query())})).addTypeVariable(TypeVariableName.get((String)"U", (TypeName[])new TypeName[]{this.paraType(IWrapper.class, "?", "U", this.fluent.query())})).superclass(this.paraType(WhereBase.class, "W", "U", this.fluent.query())).addJavadoc("query/update where\u6761\u4ef6\u8bbe\u7f6e", new Object[0]).addMethod(this.construct1_EntityWhere()).addMethod(this.construct2_EntityWhere());
        for (CommonField fc : this.fluent.getFields()) {
            this.buildWhereCondition(builder, fc);
        }
        return builder.build();
    }

    private TypeSpec nestedQueryWhere() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"QueryWhere").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass(super.paraType("EntityWhere", "QueryWhere", this.fluent.query())).addJavadoc("query where\u6761\u4ef6\u8bbe\u7f6e", new Object[0]).addMethod(this.construct1_QueryWhere()).addMethod(this.construct2_QueryWhere()).addMethod(this.m_buildOr_QueryWhere());
        return builder.build();
    }

    private TypeSpec nestedUpdateWhere() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"UpdateWhere").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass(super.paraType("EntityWhere", "UpdateWhere", this.fluent.updater())).addJavadoc("update where\u6761\u4ef6\u8bbe\u7f6e", new Object[0]).addMethod(this.construct1_UpdateWhere()).addMethod(this.construct2_UpdateWhere()).addMethod(this.m_buildOr_UpdateWhere());
        return builder.build();
    }

    private void buildWhereCondition(TypeSpec.Builder builder, CommonField fc) {
        MethodSpec.Builder field = MethodSpec.methodBuilder((String)fc.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String klassName = fc.getJavaType().toString();
        try {
            Class<?> klass = Class.forName(klassName);
            if (klass.equals(String.class)) {
                field.returns(this.whereType(StringWhere.class));
            } else if (klass.equals(Boolean.class)) {
                field.returns(this.whereType(BooleanWhere.class));
            } else if (Number.class.isAssignableFrom(klass)) {
                field.returns(this.whereType(NumericWhere.class));
            } else {
                field.returns(this.whereType(ObjectWhere.class));
            }
        }
        catch (Exception e) {
            field.returns(this.whereType(ObjectWhere.class));
        }
        field.addStatement("return this.set($L)", new Object[]{this.varSegment(fc.getName())});
        builder.addMethod(field.build());
    }

    private TypeName whereType(Class whereKlass) {
        return this.paraType(ClassName.get((Class)whereKlass), TypeVariableName.get((String)"W"), this.fluent.query());
    }

    private MethodSpec m_aggregate_Having() {
        return MethodSpec.methodBuilder((String)"aggregateSegment").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(ClassName.get(Override.class)).addParameter((TypeName)ClassName.get(IAggregate.class), "aggregate", new Modifier[0]).returns((TypeName)this.fluent.having()).addStatement("return new Having(this, aggregate)", new Object[0]).build();
    }

    private MethodSpec m_aggregate_Selector() {
        return MethodSpec.methodBuilder((String)"aggregateSegment").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(ClassName.get(Override.class)).addParameter((TypeName)ClassName.get(IAggregate.class), "aggregate", new Modifier[0]).returns((TypeName)this.fluent.selector()).addStatement("return new Selector(this, aggregate)", new Object[0]).build();
    }

    private MethodSpec constructor1() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.fluent.query(), "query", new Modifier[0]).addStatement("super(query)", new Object[0]).build();
    }

    private MethodSpec constructor1_Update() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.fluent.updater(), "updater", new Modifier[0]).addStatement("super(updater)", new Object[0]).build();
    }

    private MethodSpec constructor2_Having() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.fluent.having(), "having", new Modifier[0]).addParameter((TypeName)ClassName.get(IAggregate.class), "aggregate", new Modifier[0]).addStatement("super(having, aggregate)", new Object[0]).build();
    }

    private MethodSpec constructor2_Selector() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)this.fluent.selector(), "selector", new Modifier[0]).addParameter((TypeName)ClassName.get(IAggregate.class), "aggregate", new Modifier[0]).addStatement("super(selector, aggregate)", new Object[0]).build();
    }

    private MethodSpec m_set_ISegment() {
        return MethodSpec.methodBuilder((String)"set").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get(FieldMapping.class), "fieldMapping", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"R")).build();
    }

    private MethodSpec construct1_EntityWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeVariableName.get((String)"U"), "wrapper", new Modifier[0]).addStatement("super(wrapper)", new Object[0]).build();
    }

    private MethodSpec construct2_EntityWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)TypeVariableName.get((String)"U"), "wrapper", new Modifier[0]).addParameter((TypeName)TypeVariableName.get((String)"W"), "where", new Modifier[0]).addStatement("super(wrapper, where)", new Object[0]).build();
    }

    private MethodSpec construct1_QueryWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.fluent.query(), "query", new Modifier[0]).addStatement("super(query)", new Object[0]).build();
    }

    private MethodSpec construct2_QueryWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.fluent.query(), "query", new Modifier[0]).addParameter((TypeName)this.fluent.queryWhere(), "where", new Modifier[0]).addStatement("super(query, where)", new Object[0]).build();
    }

    private MethodSpec construct1_UpdateWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.fluent.updater(), "updater", new Modifier[0]).addStatement("super(updater)", new Object[0]).build();
    }

    private MethodSpec construct2_UpdateWhere() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.fluent.updater(), "updater", new Modifier[0]).addParameter((TypeName)this.fluent.updateWhere(), "where", new Modifier[0]).addStatement("super(updater, where)", new Object[0]).build();
    }

    private MethodSpec m_buildOr_QueryWhere() {
        return MethodSpec.methodBuilder((String)"buildOr").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter((TypeName)this.fluent.queryWhere(), "and", new Modifier[0]).returns((TypeName)this.fluent.queryWhere()).addStatement("return new QueryWhere(($T) this.wrapper, and)", new Object[]{this.fluent.query()}).build();
    }

    private MethodSpec m_buildOr_UpdateWhere() {
        return MethodSpec.methodBuilder((String)"buildOr").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter((TypeName)this.fluent.updateWhere(), "and", new Modifier[0]).returns((TypeName)this.fluent.updateWhere()).addStatement("return new UpdateWhere(($T) this.wrapper, and)", new Object[]{this.fluent.updater()}).build();
    }

    @Override
    protected boolean isInterface() {
        return true;
    }

    private String varAggregate(String name) {
        if (CONFLICT_AGGREGATE.contains(name) || CONFLICT_SEGMENT.contains(name)) {
            return this.fluent.entityMapping().simpleName() + "." + name;
        }
        return name;
    }

    private String varSegment(String name) {
        if (CONFLICT_SEGMENT.contains(name)) {
            return this.fluent.entityMapping().simpleName() + "." + name;
        }
        return name;
    }
}

