/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.status2.transitor.tx.impl;

import com.godmonth.status2.analysis.intf.ModelAnalysis;
import com.godmonth.status2.transitor.core.intf.StatusTransitor;
import com.godmonth.status2.transitor.tx.impl.Merger;
import com.godmonth.status2.transitor.tx.intf.StatusEntry;
import com.godmonth.status2.transitor.tx.intf.TransitedResult;
import com.godmonth.status2.transitor.tx.intf.TriggerBehavior;
import com.godmonth.status2.transitor.tx.intf.TxStatusTransitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class TxStatusTransitorImpl<MODEL, STATUS, TRIGGER>
implements TxStatusTransitor<MODEL, TRIGGER> {
    private static final Logger log = LoggerFactory.getLogger(TxStatusTransitorImpl.class);
    protected ModelAnalysis<MODEL> modelAnalysis;
    protected StatusTransitor<STATUS, TRIGGER> statusTransitor;
    protected Function<STATUS, StatusEntry<MODEL, Object>> statusEntryFunction;
    protected TransactionOperations transactionOperations;
    protected Merger<MODEL> modelMerger;

    public static <STATUS, MODEL> Function<STATUS, StatusEntry<MODEL, Object>> convert(List<Pair<STATUS, StatusEntry>> entryBindList) {
        HashMap<Object, Object> statusStatusEntryMap = new HashMap<Object, Object>();
        for (Pair<STATUS, StatusEntry> binding : entryBindList) {
            statusStatusEntryMap.put(binding.getKey(), binding.getValue());
        }
        return statusStatusEntryMap::get;
    }

    public void setStatusEntryBindingList(List<Pair<STATUS, StatusEntry>> entryBindingList) {
        this.setStatusEntryFunction(TxStatusTransitorImpl.convert(entryBindingList));
    }

    public void setStatusEntryBindingMap(Map<STATUS, StatusEntry> entryBindingMap) {
        this.setStatusEntryFunction(entryBindingMap::get);
    }

    @Override
    public MODEL transit(MODEL model, TriggerBehavior<TRIGGER, MODEL> triggerBehavior) {
        STATUS nextStatus = this.beforeChange(model, triggerBehavior.getTrigger());
        TransitedResult transitedResult = (TransitedResult)this.transactionOperations.execute(status -> {
            this.modelAnalysis.setStatus(model, nextStatus);
            Object accessory = null;
            if (triggerBehavior.getTransitionCallback() != null) {
                accessory = triggerBehavior.getTransitionCallback().beforeMerge(model);
            }
            Object mergedModelInTx = this.modelMerger.mergeInTx(model);
            return new TransitedResult<Object, Object>(mergedModelInTx, accessory);
        });
        this.afterChange(transitedResult);
        return transitedResult.getModel();
    }

    protected STATUS beforeChange(MODEL model, TRIGGER trigger) {
        Object status = this.modelAnalysis.getStatus(model);
        Validate.notNull((Object)status, (String)"status is null", (Object[])new Object[0]);
        Object nextStatus = this.statusTransitor.transit(status, trigger);
        Validate.notNull((Object)nextStatus, (String)"nextStatus is null", (Object[])new Object[0]);
        return (STATUS)nextStatus;
    }

    protected void afterChange(TransitedResult<MODEL, Object> transitedResult) {
        StatusEntry<MODEL, Object> statusEntry;
        Object status = this.modelAnalysis.getStatus(transitedResult.getModel());
        Validate.notNull((Object)status, (String)"status is null", (Object[])new Object[0]);
        if (this.statusEntryFunction != null && (statusEntry = this.statusEntryFunction.apply(status)) != null) {
            statusEntry.nextStatusEntry(transitedResult);
        }
    }

    public static <MODEL, STATUS, TRIGGER> TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> builder() {
        return new TxStatusTransitorImplBuilder();
    }

    public TxStatusTransitorImpl(ModelAnalysis<MODEL> modelAnalysis, StatusTransitor<STATUS, TRIGGER> statusTransitor, Function<STATUS, StatusEntry<MODEL, Object>> statusEntryFunction, TransactionOperations transactionOperations, Merger<MODEL> modelMerger) {
        this.modelAnalysis = modelAnalysis;
        this.statusTransitor = statusTransitor;
        this.statusEntryFunction = statusEntryFunction;
        this.transactionOperations = transactionOperations;
        this.modelMerger = modelMerger;
    }

    public TxStatusTransitorImpl() {
    }

    public void setModelAnalysis(ModelAnalysis<MODEL> modelAnalysis) {
        this.modelAnalysis = modelAnalysis;
    }

    public void setStatusTransitor(StatusTransitor<STATUS, TRIGGER> statusTransitor) {
        this.statusTransitor = statusTransitor;
    }

    public void setStatusEntryFunction(Function<STATUS, StatusEntry<MODEL, Object>> statusEntryFunction) {
        this.statusEntryFunction = statusEntryFunction;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    public void setModelMerger(Merger<MODEL> modelMerger) {
        this.modelMerger = modelMerger;
    }

    public static class TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> {
        private ModelAnalysis<MODEL> modelAnalysis;
        private StatusTransitor<STATUS, TRIGGER> statusTransitor;
        private TransactionOperations transactionOperations;
        private Merger<MODEL> modelMerger;
        protected Function<STATUS, StatusEntry<MODEL, Object>> statusEntryFunction;

        public TxStatusTransitorImplBuilder statusEntryBindList(List<Pair<STATUS, StatusEntry>> entryBindList) {
            this.statusEntryFunction = TxStatusTransitorImpl.convert(entryBindList);
            return this;
        }

        TxStatusTransitorImplBuilder() {
        }

        public TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> modelAnalysis(ModelAnalysis<MODEL> modelAnalysis) {
            this.modelAnalysis = modelAnalysis;
            return this;
        }

        public TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> statusTransitor(StatusTransitor<STATUS, TRIGGER> statusTransitor) {
            this.statusTransitor = statusTransitor;
            return this;
        }

        public TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> statusEntryFunction(Function<STATUS, StatusEntry<MODEL, Object>> statusEntryFunction) {
            this.statusEntryFunction = statusEntryFunction;
            return this;
        }

        public TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> transactionOperations(TransactionOperations transactionOperations) {
            this.transactionOperations = transactionOperations;
            return this;
        }

        public TxStatusTransitorImplBuilder<MODEL, STATUS, TRIGGER> modelMerger(Merger<MODEL> modelMerger) {
            this.modelMerger = modelMerger;
            return this;
        }

        public TxStatusTransitorImpl<MODEL, STATUS, TRIGGER> build() {
            return new TxStatusTransitorImpl<MODEL, STATUS, TRIGGER>(this.modelAnalysis, this.statusTransitor, this.statusEntryFunction, this.transactionOperations, this.modelMerger);
        }

        public String toString() {
            return "TxStatusTransitorImpl.TxStatusTransitorImplBuilder(modelAnalysis=" + this.modelAnalysis + ", statusTransitor=" + this.statusTransitor + ", statusEntryFunction=" + this.statusEntryFunction + ", transactionOperations=" + this.transactionOperations + ", modelMerger=" + this.modelMerger + ")";
        }
    }
}

