/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.consensus;

import com.obs.services.internal.consensus.CacheData;
import com.obs.services.model.AuthTypeEnum;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager {
    private ConcurrentHashMap<String, CacheData> apiVersionCache = new ConcurrentHashMap();

    public static CacheManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void addApiVersion(String bucketName, AuthTypeEnum apiVersion) {
        this.apiVersionCache.put(bucketName, new CacheData(apiVersion));
    }

    public AuthTypeEnum getApiVersionInCache(String bucketName) {
        CacheData authTypeCache = this.apiVersionCache.get(bucketName);
        return this.isValid(authTypeCache) ? authTypeCache.getApiVersion() : null;
    }

    public void clear() {
        if (this.apiVersionCache != null) {
            this.apiVersionCache.clear();
        }
    }

    public boolean isValid(CacheData authTypeCache) {
        return authTypeCache != null && authTypeCache.getExpirationTime() >= new Date().getTime();
    }

    private static class SingletonHolder {
        private static final CacheManager INSTANCE = new CacheManager();

        private SingletonHolder() {
        }
    }
}

