/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.logger;

import android.os.Environment;
import com.klinker.android.logger.OnLogListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final String TAG = "Log";
    private static boolean DEBUG_ENABLED = false;
    private static String PATH = "ApplicationLog.txt";
    private static OnLogListener logListener;

    public static void setDebug(boolean debug) {
        DEBUG_ENABLED = debug;
    }

    public static void setPath(String path) {
        PATH = path.endsWith("/") ? path + "ApplicationLog.txt" : (!path.endsWith(".txt") ? path + ".txt" : path);
    }

    public static void setLogListener(OnLogListener listener) {
        logListener = listener;
    }

    public static void e(String tag, String message) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.e((String)tag, (String)message)) > 0) {
            Log.logToFile(tag, message);
        }
    }

    public static void e(String tag, String message, Throwable error) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.e((String)tag, (String)message, (Throwable)error)) > 0) {
            Log.logToFile(tag, message + "\r\n" + android.util.Log.getStackTraceString((Throwable)error));
        }
    }

    public static void v(String tag, String message) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.v((String)tag, (String)message)) > 0) {
            Log.logToFile(tag, message);
        }
    }

    public static void v(String tag, String message, Throwable error) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.v((String)tag, (String)message, (Throwable)error)) > 0) {
            Log.logToFile(tag, message + "\r\n" + android.util.Log.getStackTraceString((Throwable)error));
        }
    }

    public static void d(String tag, String message) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.d((String)tag, (String)message)) > 0) {
            Log.logToFile(tag, message);
        }
    }

    public static void d(String tag, String message, Throwable error) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.d((String)tag, (String)message, (Throwable)error)) > 0) {
            Log.logToFile(tag, message + "\r\n" + android.util.Log.getStackTraceString((Throwable)error));
        }
    }

    public static void i(String tag, String message) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.i((String)tag, (String)message)) > 0) {
            Log.logToFile(tag, message);
        }
    }

    public static void i(String tag, String message, Throwable error) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.i((String)tag, (String)message, (Throwable)error)) > 0) {
            Log.logToFile(tag, message + "\r\n" + android.util.Log.getStackTraceString((Throwable)error));
        }
    }

    public static void w(String tag, String message) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.w((String)tag, (String)message)) > 0) {
            Log.logToFile(tag, message);
        }
    }

    public static void w(String tag, String message, Throwable error) {
        int logResult;
        if (DEBUG_ENABLED && (logResult = android.util.Log.w((String)tag, (String)message, (Throwable)error)) > 0) {
            Log.logToFile(tag, message + "\r\n" + android.util.Log.getStackTraceString((Throwable)error));
        }
    }

    public static boolean isLoggable(String string, int num) {
        return true;
    }

    private static String getDateTimeStamp() {
        Date dateNow = Calendar.getInstance().getTime();
        return DateFormat.getDateTimeInstance(3, 3, Locale.US).format(dateNow);
    }

    private static void logToFile(String tag, String message) {
        try {
            File logFile = new File(Environment.getExternalStorageDirectory(), PATH);
            if (!logFile.exists()) {
                logFile.getParentFile().mkdirs();
                logFile.createNewFile();
            }
            if (logFile.length() > 0x200000L) {
                logFile.delete();
                logFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
            writer.write(String.format("%1s [%2s]:%3s\r\n", Log.getDateTimeStamp(), tag, message));
            writer.close();
            if (logListener != null) {
                logListener.onLogged(tag, message);
            }
        }
        catch (IOException e) {
            android.util.Log.e((String)TAG, (String)"Unable to log exception to file.", (Throwable)e);
        }
    }
}

