/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.api;

import com.lmax.solana4j.client.api.TokenAmount;
import java.util.List;
import java.util.Map;

public interface TransactionResponse {
    public long getSlot();

    public Long getBlockTime();

    public String getVersion();

    public TransactionData getTransactionData();

    public TransactionMetadata getMetadata();

    public static interface Instruction {
        public InstructionAccounts getAccounts();

        public String getData();

        public Integer getProgramIdIndex();

        public String getProgram();

        public String getProgramId();

        public Map<String, Object> getInstructionParsed();

        public Integer getStackHeight();

        public static interface InstructionAccounts {
            public List<Integer> getIndexes();

            public List<String> getAddresses();
        }
    }

    public static interface InnerInstruction {
        public long getIndex();

        public List<Instruction> getInstructions();
    }

    public static interface Message {
        public AccountKeys getAccountKeys();

        public Header getHeader();

        public List<Instruction> getInstructions();

        public String getRecentBlockhash();

        public static interface Header {
            public int getNumReadonlySignedAccounts();

            public int getNumReadonlyUnsignedAccounts();

            public int getNumRequiredSignatures();
        }

        public static interface AccountKeys {
            public List<AccountKeyParsed> getParsedAccountKeys();

            public List<String> getEncodedAccountKeys();

            public static interface AccountKeyParsed {
                public String getKey();

                public KeySource getSource();

                public boolean isSigner();

                public boolean isWritable();

                public static enum KeySource {
                    TRANSACTION,
                    LOOKUPTABLE;

                }
            }
        }
    }

    public static interface TransactionMetadata {
        public Object getErr();

        public long getFee();

        public List<InnerInstruction> getInnerInstructions();

        public List<String> getLogMessages();

        public List<Long> getPreBalances();

        public List<Long> getPostBalances();

        public List<TokenBalance> getPreTokenBalances();

        public List<TokenBalance> getPostTokenBalances();

        public List<Reward> getRewards();

        public long getComputeUnitsConsumed();

        public LoadedAddresses getLoadedAddresses();

        public Map.Entry<String, Object> getStatus();

        public static interface TokenBalance {
            public int getAccountIndex();

            public String getMint();

            public String getOwner();

            public String getProgramId();

            public TokenAmount getUiTokenAmount();
        }

        public static interface Reward {
            public String getPubkey();

            public long getLamports();

            public long getPostBalance();

            public String getRewardType();

            public int getCommission();
        }

        public static interface LoadedAddresses {
            public List<String> getReadonly();

            public List<String> getWritable();
        }
    }

    public static interface TransactionData {
        public TransactionDataParsed getParsedTransactionData();

        public List<String> getEncodedTransactionData();

        public static interface TransactionDataParsed {
            public Message getMessage();

            public List<String> getSignatures();
        }
    }
}

