/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.lmax.solana4j.client.api.AccountInfo;
import com.lmax.solana4j.client.api.SolanaRpcResponse;
import com.lmax.solana4j.client.jsonrpc.ContextDTO;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class AccountInfoDTO
implements SolanaRpcResponse<AccountInfo> {
    private final ContextDTO context;
    private final AccountInfoValueDTO value;

    @JsonCreator
    AccountInfoDTO(@JsonProperty(value="context") ContextDTO context, @JsonProperty(value="value") AccountInfoValueDTO value) {
        this.context = context;
        this.value = value;
    }

    @Override
    public SolanaRpcResponse.Context getContext() {
        return this.context;
    }

    @Override
    public AccountInfo getValue() {
        return this.value;
    }

    public String toString() {
        return "AccountInfoDTO{context=" + String.valueOf(this.context) + ", value=" + String.valueOf(this.value) + "}";
    }

    @JsonDeserialize(using=AccountInfoDataDeserializer.class)
    static final class AccountInfoDataDTO
    implements AccountInfo.AccountInfoData {
        private final List<String> accountInfoEncoded;
        private final AccountInfo.AccountInfoData.AccountInfoParsedData accountInfoParsed;

        AccountInfoDataDTO(List<String> accountInfoEncoded, AccountInfoParsedDataDTO accountInfoParsed) {
            this.accountInfoEncoded = accountInfoEncoded;
            this.accountInfoParsed = accountInfoParsed;
        }

        @Override
        public List<String> getAccountInfoEncoded() {
            return this.accountInfoEncoded;
        }

        @Override
        public AccountInfo.AccountInfoData.AccountInfoParsedData getAccountInfoParsed() {
            return this.accountInfoParsed;
        }

        static class AccountInfoParsedDataDTO
        implements AccountInfo.AccountInfoData.AccountInfoParsedData {
            private final String program;
            private final int space;
            private final Map<String, Object> parsedData;

            AccountInfoParsedDataDTO(@JsonProperty(value="program") String program, @JsonProperty(value="space") int space, @JsonProperty(value="parsed") Map<String, Object> parsedData) {
                this.program = program;
                this.space = space;
                this.parsedData = parsedData;
            }

            @Override
            public String getProgram() {
                return this.program;
            }

            @Override
            public int getSpace() {
                return this.space;
            }

            @Override
            public Map<String, Object> getParsedData() {
                return this.parsedData;
            }
        }

        public static class AccountInfoDataDeserializer
        extends JsonDeserializer<AccountInfo.AccountInfoData> {
            public AccountInfo.AccountInfoData deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
                ObjectMapper mapper = (ObjectMapper)parser.getCodec();
                JsonNode node = (JsonNode)mapper.readTree(parser);
                if (node.isArray()) {
                    List accountInfoEncoded = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                    return new AccountInfoDataDTO(accountInfoEncoded, null);
                }
                if (node.isObject()) {
                    AccountInfoParsedDataDTO accountInfoParsedData = (AccountInfoParsedDataDTO)mapper.convertValue((Object)node, AccountInfoParsedDataDTO.class);
                    return new AccountInfoDataDTO(null, accountInfoParsedData);
                }
                throw new IOException("Unable to deserialize Transaction Data.");
            }
        }
    }

    static final class AccountInfoValueDTO
    implements AccountInfo {
        private final long lamports;
        private final String owner;
        private final AccountInfo.AccountInfoData data;
        private final boolean executable;
        private final String rentEpoch;
        private final int space;

        @JsonCreator
        AccountInfoValueDTO(@JsonProperty(value="lamports") long lamports, @JsonProperty(value="owner") String owner, @JsonProperty(value="data") AccountInfoDataDTO data, @JsonProperty(value="executable") boolean executable, @JsonProperty(value="rentEpoch") String rentEpoch, @JsonProperty(value="space") int space) {
            this.lamports = lamports;
            this.owner = owner;
            this.data = data;
            this.executable = executable;
            this.rentEpoch = rentEpoch;
            this.space = space;
        }

        @Override
        public long getLamports() {
            return this.lamports;
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public AccountInfo.AccountInfoData getData() {
            return this.data;
        }

        @Override
        public boolean isExecutable() {
            return this.executable;
        }

        @Override
        public String getRentEpoch() {
            return this.rentEpoch;
        }

        @Override
        public long getSpace() {
            return this.space;
        }

        public String toString() {
            return "AccountInfoValueDTO{lamports=" + this.lamports + ", owner='" + this.owner + "', data=" + String.valueOf(this.data) + ", executable=" + this.executable + ", rentEpoch='" + this.rentEpoch + "', space=" + this.space + "}";
        }
    }
}

