/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.lmax.solana4j.client.api.BlockResponse;
import com.lmax.solana4j.client.api.TransactionResponse;
import com.lmax.solana4j.client.jsonrpc.TransactionResponseDTO;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class BlockResponseDTO
implements BlockResponse {
    private final long blockHeight;
    private final Long blockTime;
    private final String blockhashBase58;
    private final long parentSlot;
    private final String previousBlockhashBase58;
    private final List<RewardsDTO> rewards;
    private final List<TransactionResponseDTO> transactions;

    @JsonCreator
    BlockResponseDTO(@JsonProperty(value="blockHeight") long blockHeight, @JsonProperty(value="blockTime") Long blockTime, @JsonProperty(value="blockhash") String blockhashBase58, @JsonProperty(value="parentSlot") long parentSlot, @JsonProperty(value="previousBlockhash") String previousBlockhashBase58, @JsonProperty(value="rewards") List<RewardsDTO> rewards, @JsonProperty(value="transactions") List<TransactionResponseDTO> transactions) {
        this.blockHeight = blockHeight;
        this.blockTime = blockTime;
        this.blockhashBase58 = blockhashBase58;
        this.parentSlot = parentSlot;
        this.previousBlockhashBase58 = previousBlockhashBase58;
        this.rewards = rewards;
        this.transactions = transactions;
    }

    @Override
    public long getBlockHeight() {
        return this.blockHeight;
    }

    @Override
    public Long getBlockTime() {
        return this.blockTime;
    }

    @Override
    public String getBlockhash() {
        return this.blockhashBase58;
    }

    @Override
    public long getParentSlot() {
        return this.parentSlot;
    }

    @Override
    public String getPreviousBlockhash() {
        return this.previousBlockhashBase58;
    }

    @Override
    public List<BlockResponse.Rewards> getRewards() {
        return this.rewards != null ? this.rewards.stream().map(x -> x).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<TransactionResponse> getTransactions() {
        return this.transactions != null ? this.transactions.stream().map(x -> x).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String toString() {
        return "BlockResponseDTO{blockHeight=" + this.blockHeight + ", blockTime=" + this.blockTime + ", blockhashBase58='" + this.blockhashBase58 + "', parentSlot=" + this.parentSlot + ", previousBlockhashBase58='" + this.previousBlockhashBase58 + "', rewards=" + String.valueOf(this.rewards) + ", transactions=" + String.valueOf(this.transactions) + "}";
    }

    static final class RewardsDTO
    implements BlockResponse.Rewards {
        Long commission;
        long lamports;
        long postBalance;
        String pubkeyBase58;
        String rewardType;

        @JsonCreator
        RewardsDTO(@JsonProperty(value="commission") Long commission, @JsonProperty(value="lamports") long lamports, @JsonProperty(value="postBalance") long postBalance, @JsonProperty(value="pubkey") String pubkeyBase58, @JsonProperty(value="rewardType") String rewardType) {
            this.commission = commission;
            this.lamports = lamports;
            this.postBalance = postBalance;
            this.pubkeyBase58 = pubkeyBase58;
            this.rewardType = rewardType;
        }

        @Override
        public Long getCommission() {
            return this.commission;
        }

        @Override
        public long getLamports() {
            return this.lamports;
        }

        @Override
        public long getPostBalance() {
            return this.postBalance;
        }

        @Override
        public String getPubkeyBase58() {
            return this.pubkeyBase58;
        }

        @Override
        public String getRewardType() {
            return this.rewardType;
        }

        public String toString() {
            return "RewardsDTO{commission=" + this.commission + ", lamports=" + this.lamports + ", postBalance=" + this.postBalance + ", pubkeyBase58='" + this.pubkeyBase58 + "', rewardType='" + this.rewardType + "'}";
        }
    }
}

