/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.lmax.solana4j.client.jsonrpc.RpcWrapperDTO;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

final class SolanaCodec {
    static final String JSONRPC = "jsonrpc";
    static final String ID = "id";
    static final String METHOD = "method";
    static final String PARAMS = "params";
    final AtomicLong requestId = new AtomicLong();
    final ObjectMapper mapper;

    SolanaCodec(boolean failOnUnknownProperties) {
        this.mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true)).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties)).build();
    }

    String encodeRequest(String method, Object[] params) throws JsonProcessingException {
        long id = this.requestId.incrementAndGet();
        ObjectNode requestNode = this.mapper.createObjectNode();
        requestNode.put(JSONRPC, "2.0");
        requestNode.put(METHOD, method);
        requestNode.set(PARAMS, (JsonNode)this.arrayParams(params));
        requestNode.put(ID, id);
        return this.mapper.writeValueAsString((Object)requestNode);
    }

    <T> RpcWrapperDTO<T> decodeResponse(byte[] bytes, TypeReference<RpcWrapperDTO<T>> type) throws IOException {
        ObjectReader objectReader = this.mapper.readerFor(type);
        return (RpcWrapperDTO)objectReader.readValue(bytes);
    }

    private ArrayNode arrayParams(Object[] values) {
        ArrayNode newArrayParams = this.mapper.createArrayNode();
        for (Object value : values) {
            newArrayParams.add(this.mapper.valueToTree(value));
        }
        return newArrayParams;
    }
}

