/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.solana4j.client.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.lmax.solana4j.client.api.TokenAmount;
import com.lmax.solana4j.client.api.TransactionResponse;
import com.lmax.solana4j.client.jsonrpc.TokenAmountDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class TransactionResponseDTO
implements TransactionResponse {
    private final MetaDTO metaImpl;
    private final long slot;
    private final TransactionDataDTO transaction;
    private final Long blockTime;
    private final String version;

    @JsonCreator
    TransactionResponseDTO(@JsonProperty(value="meta") MetaDTO metaImpl, @JsonProperty(value="slot") long slot, @JsonProperty(value="transaction") TransactionDataDTO transaction, @JsonProperty(value="blockTime") Long blockTime, @JsonProperty(value="version") String version) {
        this.metaImpl = metaImpl;
        this.slot = slot;
        this.transaction = transaction;
        this.blockTime = blockTime;
        this.version = version;
    }

    @Override
    @JsonProperty(value="meta")
    public TransactionResponse.TransactionMetadata getMetadata() {
        return this.metaImpl;
    }

    @Override
    public long getSlot() {
        return this.slot;
    }

    @Override
    public TransactionResponse.TransactionData getTransactionData() {
        return this.transaction;
    }

    @Override
    public Long getBlockTime() {
        return this.blockTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "TransactionResponseDTO{metaImpl=" + String.valueOf(this.metaImpl) + ", slot=" + this.slot + ", transaction=" + String.valueOf(this.transaction) + ", blockTime=" + this.blockTime + ", version='" + this.version + "'}";
    }

    static final class LoadedAddressesDTO
    implements TransactionResponse.TransactionMetadata.LoadedAddresses {
        private final List<String> readonly;
        private final List<String> writable;

        @JsonCreator
        LoadedAddressesDTO(@JsonProperty(value="readonly") List<String> readonly, @JsonProperty(value="writable") List<String> writable) {
            this.readonly = readonly;
            this.writable = writable;
        }

        @Override
        public List<String> getReadonly() {
            return this.readonly;
        }

        @Override
        public List<String> getWritable() {
            return this.writable;
        }
    }

    static final class MessageDTO
    implements TransactionResponse.Message {
        private final AccountKeysDTO accountKeys;
        private final HeaderDTO headerImpl;
        private final List<InstructionDTO> instructions;
        private final String recentBlockhash;

        @JsonCreator
        MessageDTO(@JsonProperty(value="accountKeys") AccountKeysDTO accountKeys, @JsonProperty(value="header") HeaderDTO headerImpl, @JsonProperty(value="instructions") List<InstructionDTO> instructions, @JsonProperty(value="recentBlockhash") String recentBlockhash) {
            this.accountKeys = accountKeys;
            this.headerImpl = headerImpl;
            this.instructions = instructions;
            this.recentBlockhash = recentBlockhash;
        }

        @Override
        public TransactionResponse.Message.AccountKeys getAccountKeys() {
            return this.accountKeys;
        }

        @Override
        public TransactionResponse.Message.Header getHeader() {
            return this.headerImpl;
        }

        @Override
        public List<TransactionResponse.Instruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public String getRecentBlockhash() {
            return this.recentBlockhash;
        }

        public String toString() {
            return "MessageDTO{accountKeys=" + String.valueOf(this.accountKeys) + ", headerImpl=" + String.valueOf(this.headerImpl) + ", instructions=" + String.valueOf(this.instructions) + ", recentBlockhash='" + this.recentBlockhash + "'}";
        }

        @JsonDeserialize(using=InstructionParsedDeserializer.class)
        static final class InstructionParsedDTO {
            private final Map<String, Object> parsedInstruction;

            InstructionParsedDTO(Map<String, Object> parsedInstruction) {
                this.parsedInstruction = parsedInstruction;
            }

            public Map<String, Object> get() {
                return this.parsedInstruction;
            }

            private static class InstructionParsedDeserializer
            extends JsonDeserializer<InstructionParsedDTO> {
                private InstructionParsedDeserializer() {
                }

                public InstructionParsedDTO deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                    ObjectMapper mapper = (ObjectMapper)parser.getCodec();
                    JsonNode node = (JsonNode)mapper.readTree(parser);
                    if (node.isTextual()) {
                        return new InstructionParsedDTO(Map.of("", node.asText()));
                    }
                    if (node.isObject()) {
                        Map parsed = (Map)mapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        return new InstructionParsedDTO(parsed);
                    }
                    throw new IllegalArgumentException("Unsupported node type: " + String.valueOf(node.getNodeType()));
                }
            }
        }

        @JsonDeserialize(using=InstructionAccountsDeserializer.class)
        static final class InstructionAccountsDTO
        implements TransactionResponse.Instruction.InstructionAccounts {
            private final List<Integer> indexes;
            private final List<String> addresses;

            InstructionAccountsDTO(List<Integer> indexes, List<String> addresses) {
                this.indexes = indexes;
                this.addresses = addresses;
            }

            @Override
            public List<Integer> getIndexes() {
                return this.indexes;
            }

            @Override
            public List<String> getAddresses() {
                return this.addresses;
            }

            static class InstructionAccountsDeserializer
            extends JsonDeserializer<InstructionAccountsDTO> {
                InstructionAccountsDeserializer() {
                }

                public InstructionAccountsDTO deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                    ObjectMapper mapper = (ObjectMapper)parser.getCodec();
                    JsonNode node = (JsonNode)mapper.readTree(parser);
                    if (node.isArray()) {
                        if (!node.isEmpty() && node.get(0).isTextual()) {
                            List addresses = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                            return new InstructionAccountsDTO(null, addresses);
                        }
                        List indexes = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, Integer.class));
                        return new InstructionAccountsDTO(indexes, null);
                    }
                    throw new IOException("Unable to deserialize instruction accounts.");
                }
            }
        }

        static final class InstructionDTO
        implements TransactionResponse.Instruction {
            private final InstructionAccountsDTO accounts;
            private final InstructionParsedDTO instructionParsed;
            private final String data;
            private final String program;
            private final String programId;
            private final Integer programIdIndex;
            private final Integer stackHeight;

            @JsonCreator
            InstructionDTO(@JsonProperty(value="accounts") InstructionAccountsDTO accounts, @JsonProperty(value="parsed") InstructionParsedDTO instructionParsed, @JsonProperty(value="data") String data, @JsonProperty(value="program") String program, @JsonProperty(value="programId") String programId, @JsonProperty(value="programIdIndex") Integer programIdIndex, @JsonProperty(value="stackHeight") Integer stackHeight) {
                this.accounts = accounts;
                this.instructionParsed = instructionParsed;
                this.data = data;
                this.program = program;
                this.programId = programId;
                this.programIdIndex = programIdIndex;
                this.stackHeight = stackHeight;
            }

            @Override
            public TransactionResponse.Instruction.InstructionAccounts getAccounts() {
                return this.accounts;
            }

            @Override
            public String getData() {
                return this.data;
            }

            @Override
            public Integer getProgramIdIndex() {
                return this.programIdIndex;
            }

            @Override
            public String getProgram() {
                return this.program;
            }

            @Override
            public String getProgramId() {
                return this.programId;
            }

            @Override
            public Map<String, Object> getInstructionParsed() {
                return this.instructionParsed != null ? this.instructionParsed.get() : null;
            }

            @Override
            public Integer getStackHeight() {
                return this.stackHeight;
            }

            public String toString() {
                return "InstructionDTO{accounts=" + String.valueOf(this.accounts) + ", instructionParsed=" + String.valueOf(this.instructionParsed) + ", data='" + this.data + "', program='" + this.program + "', programId='" + this.programId + "', programIdIndex=" + this.programIdIndex + ", stackHeight=" + this.stackHeight + "}";
            }
        }

        static final class HeaderDTO
        implements TransactionResponse.Message.Header {
            private final int numReadonlySignedAccounts;
            private final int numReadonlyUnsignedAccounts;
            private final int numRequiredSignatures;

            @JsonCreator
            HeaderDTO(@JsonProperty(value="numReadonlySignedAccounts") int numReadonlySignedAccounts, @JsonProperty(value="numReadonlyUnsignedAccounts") int numReadonlyUnsignedAccounts, @JsonProperty(value="numRequiredSignatures") int numRequiredSignatures) {
                this.numReadonlySignedAccounts = numReadonlySignedAccounts;
                this.numReadonlyUnsignedAccounts = numReadonlyUnsignedAccounts;
                this.numRequiredSignatures = numRequiredSignatures;
            }

            @Override
            public int getNumReadonlySignedAccounts() {
                return this.numReadonlySignedAccounts;
            }

            @Override
            public int getNumReadonlyUnsignedAccounts() {
                return this.numReadonlyUnsignedAccounts;
            }

            @Override
            public int getNumRequiredSignatures() {
                return this.numRequiredSignatures;
            }

            public String toString() {
                return "Header{numReadonlySignedAccounts=" + this.numReadonlySignedAccounts + ", numReadonlyUnsignedAccounts=" + this.numReadonlyUnsignedAccounts + ", numRequiredSignatures=" + this.numRequiredSignatures + "}";
            }
        }

        @JsonDeserialize(using=AccountKeyDeserializer.class)
        static final class AccountKeysDTO
        implements TransactionResponse.Message.AccountKeys {
            private final List<String> accountKeysEncoded;
            private final List<TransactionResponse.Message.AccountKeys.AccountKeyParsed> accountKeysParsed;

            AccountKeysDTO(List<String> accountKeysEncoded, List<TransactionResponse.Message.AccountKeys.AccountKeyParsed> accountKeysParsed) {
                this.accountKeysEncoded = accountKeysEncoded;
                this.accountKeysParsed = accountKeysParsed;
            }

            @Override
            public List<TransactionResponse.Message.AccountKeys.AccountKeyParsed> getParsedAccountKeys() {
                return this.accountKeysParsed;
            }

            @Override
            public List<String> getEncodedAccountKeys() {
                return this.accountKeysEncoded;
            }

            static class AccountKeyDeserializer
            extends JsonDeserializer<AccountKeysDTO> {
                AccountKeyDeserializer() {
                }

                public AccountKeysDTO deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                    ObjectMapper mapper = (ObjectMapper)parser.getCodec();
                    JsonNode node = (JsonNode)mapper.readTree(parser);
                    if (node.isArray()) {
                        if (!node.isEmpty() && node.get(0).isTextual()) {
                            List accountKeysDecoded = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                            return new AccountKeysDTO(accountKeysDecoded, null);
                        }
                        List accountKeysParsed = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, AccountKeyParsedDTO.class));
                        return new AccountKeysDTO(null, accountKeysParsed);
                    }
                    throw new IOException("Unable to deserialize Account Key.");
                }
            }

            static final class AccountKeyParsedDTO
            implements TransactionResponse.Message.AccountKeys.AccountKeyParsed {
                private final String key;
                private final TransactionResponse.Message.AccountKeys.AccountKeyParsed.KeySource source;
                private final boolean signer;
                private final boolean writable;

                @JsonCreator
                AccountKeyParsedDTO(@JsonProperty(value="pubkey") String key, @JsonProperty(value="source") TransactionResponse.Message.AccountKeys.AccountKeyParsed.KeySource source, @JsonProperty(value="signer") boolean signer, @JsonProperty(value="writable") boolean writable) {
                    this.key = key;
                    this.source = source;
                    this.signer = signer;
                    this.writable = writable;
                }

                @Override
                public String getKey() {
                    return this.key;
                }

                @Override
                public TransactionResponse.Message.AccountKeys.AccountKeyParsed.KeySource getSource() {
                    return this.source;
                }

                @Override
                public boolean isSigner() {
                    return this.signer;
                }

                @Override
                public boolean isWritable() {
                    return this.writable;
                }

                public String toString() {
                    return "AccountKeyDTO{key='" + this.key + "', source=" + String.valueOf((Object)this.source) + ", signer=" + this.signer + ", writable=" + this.writable + "}";
                }
            }
        }
    }

    @JsonDeserialize(using=TransactionDataDeserializer.class)
    static class TransactionDataDTO
    implements TransactionResponse.TransactionData {
        private final List<String> transactionDataEncoded;
        private final TransactionResponse.TransactionData.TransactionDataParsed transactionDataParsed;

        TransactionDataDTO(List<String> transactionDataEncoded, TransactionResponse.TransactionData.TransactionDataParsed transactionDataParsed) {
            this.transactionDataEncoded = transactionDataEncoded;
            this.transactionDataParsed = transactionDataParsed;
        }

        @Override
        public List<String> getEncodedTransactionData() {
            return this.transactionDataEncoded;
        }

        @Override
        public TransactionResponse.TransactionData.TransactionDataParsed getParsedTransactionData() {
            return this.transactionDataParsed;
        }

        static class TransactionDataDeserializer
        extends JsonDeserializer<TransactionDataDTO> {
            TransactionDataDeserializer() {
            }

            public TransactionDataDTO deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                ObjectMapper mapper = (ObjectMapper)parser.getCodec();
                JsonNode node = (JsonNode)mapper.readTree(parser);
                if (node.isArray()) {
                    List transactionDataEncoded = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                    return new TransactionDataDTO(transactionDataEncoded, null);
                }
                if (node.isObject()) {
                    TransactionResponse.TransactionData.TransactionDataParsed transactionDataParsed = (TransactionResponse.TransactionData.TransactionDataParsed)mapper.convertValue((Object)node, TransactionDataParsedDTO.class);
                    return new TransactionDataDTO(null, transactionDataParsed);
                }
                throw new IOException("Unable to deserialize Transaction Data.");
            }
        }

        private static final class TransactionDataParsedDTO
        implements TransactionResponse.TransactionData.TransactionDataParsed {
            private final MessageDTO message;
            private final List<String> signatures;

            @JsonCreator
            TransactionDataParsedDTO(@JsonProperty(value="message") MessageDTO message, @JsonProperty(value="signatures") List<String> signatures) {
                this.message = message;
                this.signatures = signatures;
            }

            @Override
            public TransactionResponse.Message getMessage() {
                return this.message;
            }

            @Override
            public List<String> getSignatures() {
                return this.signatures;
            }

            public String toString() {
                return "TransactionData{message=" + String.valueOf(this.message) + ", signatures=" + String.valueOf(this.signatures) + "}";
            }
        }
    }

    static final class TokenBalanceDTO
    implements TransactionResponse.TransactionMetadata.TokenBalance {
        private final int accountIndex;
        private final String mint;
        private final String owner;
        private final String programId;
        private final TokenAmountDTO.TokenAmountValueDTO uiTokenAmount;

        @JsonCreator
        TokenBalanceDTO(@JsonProperty(value="accountIndex") int accountIndex, @JsonProperty(value="mint") String mint, @JsonProperty(value="owner") String owner, @JsonProperty(value="programId") String programId, @JsonProperty(value="uiTokenAmount") TokenAmountDTO.TokenAmountValueDTO uiTokenAmount) {
            this.accountIndex = accountIndex;
            this.mint = mint;
            this.owner = owner;
            this.programId = programId;
            this.uiTokenAmount = uiTokenAmount;
        }

        @Override
        public int getAccountIndex() {
            return this.accountIndex;
        }

        @Override
        public String getMint() {
            return this.mint;
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public String getProgramId() {
            return this.programId;
        }

        @Override
        public TokenAmount getUiTokenAmount() {
            return this.uiTokenAmount;
        }

        public String toString() {
            return "TokenBalance{accountIndex=" + this.accountIndex + ", mint='" + this.mint + "', owner='" + this.owner + "', programId='" + this.programId + "', uiTokenAmount=" + String.valueOf(this.uiTokenAmount) + "}";
        }
    }

    static final class RewardDTO
    implements TransactionResponse.TransactionMetadata.Reward {
        private final String pubkey;
        private final long lamports;
        private final long postBalance;
        private final String rewardType;
        private final int commission;

        @JsonCreator
        RewardDTO(@JsonProperty(value="pubkey") String pubkey, @JsonProperty(value="lamports") long lamports, @JsonProperty(value="postBalance") long postBalance, @JsonProperty(value="rewardType") String rewardType, @JsonProperty(value="commission") int commission) {
            this.pubkey = pubkey;
            this.lamports = lamports;
            this.postBalance = postBalance;
            this.rewardType = rewardType;
            this.commission = commission;
        }

        @Override
        public String getPubkey() {
            return this.pubkey;
        }

        @Override
        public long getLamports() {
            return this.lamports;
        }

        @Override
        public long getPostBalance() {
            return this.postBalance;
        }

        @Override
        public String getRewardType() {
            return this.rewardType;
        }

        @Override
        public int getCommission() {
            return this.commission;
        }

        public String toString() {
            return "Reward{pubkey='" + this.pubkey + "', lamports=" + this.lamports + ", postBalance=" + this.postBalance + ", rewardType='" + this.rewardType + "', commission=" + this.commission + "}";
        }
    }

    static final class MetaDTO
    implements TransactionResponse.TransactionMetadata {
        public final Object err;
        public final long fee;
        public final List<InnerInstructionDTO> innerInstructions;
        public final List<String> logMessages;
        public final List<Long> postBalances;
        public final List<TokenBalanceDTO> postTokenBalances;
        public final List<Long> preBalances;
        public final List<TokenBalanceDTO> preTokenBalances;
        public final List<RewardDTO> rewards;
        public final long computeUnitsConsumed;
        private final LoadedAddressesDTO loadedAddresses;
        private final Map.Entry<String, Object> status;

        @JsonCreator
        MetaDTO(@JsonProperty(value="err") Object err, @JsonProperty(value="fee") long fee, @JsonProperty(value="innerInstructions") List<InnerInstructionDTO> innerInstructions, @JsonProperty(value="logMessages") List<String> logMessages, @JsonProperty(value="postBalances") List<Long> postBalances, @JsonProperty(value="postTokenBalances") List<TokenBalanceDTO> postTokenBalances, @JsonProperty(value="preBalances") List<Long> preBalances, @JsonProperty(value="preTokenBalances") List<TokenBalanceDTO> preTokenBalances, @JsonProperty(value="rewards") List<RewardDTO> rewards, @JsonProperty(value="computeUnitsConsumed") long computeUnitsConsumed, @JsonProperty(value="loadedAddresses") LoadedAddressesDTO loadedAddresses, @JsonProperty(value="status") Map.Entry<String, Object> status) {
            this.err = err;
            this.fee = fee;
            this.innerInstructions = innerInstructions;
            this.logMessages = logMessages;
            this.postBalances = postBalances;
            this.postTokenBalances = postTokenBalances;
            this.preBalances = preBalances;
            this.preTokenBalances = preTokenBalances;
            this.rewards = rewards;
            this.computeUnitsConsumed = computeUnitsConsumed;
            this.loadedAddresses = loadedAddresses;
            this.status = status;
        }

        @Override
        public Object getErr() {
            return this.err;
        }

        @Override
        public long getFee() {
            return this.fee;
        }

        @Override
        public List<TransactionResponse.InnerInstruction> getInnerInstructions() {
            return this.innerInstructions != null ? this.innerInstructions.stream().map(x -> x).collect(Collectors.toList()) : Collections.emptyList();
        }

        @Override
        public List<String> getLogMessages() {
            return this.logMessages;
        }

        @Override
        public List<Long> getPostBalances() {
            return this.postBalances;
        }

        @Override
        public List<TransactionResponse.TransactionMetadata.TokenBalance> getPostTokenBalances() {
            return new ArrayList<TransactionResponse.TransactionMetadata.TokenBalance>(this.postTokenBalances);
        }

        @Override
        public List<Long> getPreBalances() {
            return this.preBalances;
        }

        @Override
        public List<TransactionResponse.TransactionMetadata.TokenBalance> getPreTokenBalances() {
            return this.preTokenBalances.stream().map(x -> x).collect(Collectors.toList());
        }

        @Override
        public List<TransactionResponse.TransactionMetadata.Reward> getRewards() {
            return this.rewards.stream().map(x -> x).collect(Collectors.toList());
        }

        @Override
        public long getComputeUnitsConsumed() {
            return this.computeUnitsConsumed;
        }

        @Override
        public TransactionResponse.TransactionMetadata.LoadedAddresses getLoadedAddresses() {
            return this.loadedAddresses;
        }

        @Override
        public Map.Entry<String, Object> getStatus() {
            return this.status;
        }

        public String toString() {
            return "MetaDTO{err=" + String.valueOf(this.err) + ", fee=" + this.fee + ", innerInstructions=" + String.valueOf(this.innerInstructions) + ", logMessages=" + String.valueOf(this.logMessages) + ", postBalances=" + String.valueOf(this.postBalances) + ", postTokenBalances=" + String.valueOf(this.postTokenBalances) + ", preBalances=" + String.valueOf(this.preBalances) + ", preTokenBalances=" + String.valueOf(this.preTokenBalances) + ", rewards=" + String.valueOf(this.rewards) + ", computeUnitsConsumed=" + this.computeUnitsConsumed + ", loadedAddresses=" + String.valueOf(this.loadedAddresses) + ", status=" + String.valueOf(this.status) + "}";
        }

        static final class InnerInstructionDTO
        implements TransactionResponse.InnerInstruction {
            private final long index;
            private final List<MessageDTO.InstructionDTO> instructions;

            @JsonCreator
            InnerInstructionDTO(@JsonProperty(value="index") long index, @JsonProperty(value="instructions") List<MessageDTO.InstructionDTO> instructions) {
                this.index = index;
                this.instructions = Collections.unmodifiableList(instructions);
            }

            @Override
            public long getIndex() {
                return this.index;
            }

            @Override
            public List<TransactionResponse.Instruction> getInstructions() {
                return this.instructions;
            }

            public String toString() {
                return "InnerInstruction{index=" + this.index + ", instructions=" + String.valueOf(this.instructions) + "}";
            }
        }
    }
}

