/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.utils.bip32.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;

public class Hash {
    public static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-256", e);
        }
    }

    public static byte[] sha256Twice(byte[] bytes) {
        return Hash.sha256Twice(bytes, 0, bytes.length);
    }

    public static byte[] sha256Twice(byte[] bytes, int offset, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes, offset, length);
            digest.update(digest.digest());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-256", e);
        }
    }

    public static byte[] h160(byte[] input) {
        byte[] sha256 = Hash.sha256(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

