/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.p2p.solanaj.core.AccountMeta;

public class AccountKeysList {
    private final Map<String, AccountMeta> accounts = new LinkedHashMap<String, AccountMeta>();
    private static final Comparator<AccountMeta> metaComparator = Comparator.comparing(AccountMeta::isSigner).thenComparing(AccountMeta::isWritable).reversed();

    public void add(AccountMeta accountMeta) {
        String key = accountMeta.getPublicKey().toString();
        this.accounts.merge(key, accountMeta, (existing, newMeta) -> new AccountMeta(existing.getPublicKey(), existing.isSigner() || newMeta.isSigner(), existing.isWritable() || newMeta.isWritable()));
    }

    public void addAll(AccountKeysList metas) {
        metas.accounts.values().forEach(this::add);
    }

    public void addAll(Collection<AccountMeta> metas) {
        metas.forEach(this::add);
    }

    public ArrayList<AccountMeta> getList() {
        ArrayList<AccountMeta> accountKeysList = new ArrayList<AccountMeta>(this.accounts.values());
        accountKeysList.sort(metaComparator);
        return accountKeysList;
    }
}

