/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;
import org.p2p.solanaj.programs.SystemProgram;

public class AddressLookupTableProgram
extends Program {
    public static final PublicKey PROGRAM_ID = new PublicKey("AddressLookupTab1e1111111111111111111111111");
    private static final byte CREATE_LOOKUP_TABLE = 0;
    private static final byte FREEZE_LOOKUP_TABLE = 1;
    private static final byte EXTEND_LOOKUP_TABLE = 2;
    private static final byte DEACTIVATE_LOOKUP_TABLE = 3;
    private static final byte CLOSE_LOOKUP_TABLE = 4;

    public static TransactionInstruction createLookupTable(PublicKey authority, PublicKey payer, long recentSlot) {
        PublicKey.ProgramDerivedAddress derivedAddress = PublicKey.findProgramAddress(List.of(authority.toByteArray(), ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(recentSlot).array()), PROGRAM_ID);
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(derivedAddress.getAddress(), false, true));
        keys.add(new AccountMeta(authority, true, false));
        keys.add(new AccountMeta(payer, true, true));
        keys.add(new AccountMeta(SystemProgram.PROGRAM_ID, false, false));
        ByteBuffer data = ByteBuffer.allocate(13);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.putInt(0);
        data.putLong(recentSlot);
        data.put((byte)derivedAddress.getNonce());
        return AddressLookupTableProgram.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction freezeLookupTable(PublicKey lookupTable, PublicKey authority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(lookupTable, false, true));
        keys.add(new AccountMeta(authority, true, false));
        ByteBuffer data = ByteBuffer.allocate(1);
        data.put((byte)1);
        return AddressLookupTableProgram.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction extendLookupTable(PublicKey lookupTable, PublicKey authority, PublicKey payer, List<PublicKey> addresses) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(lookupTable, false, true));
        keys.add(new AccountMeta(authority, true, false));
        keys.add(new AccountMeta(payer, true, true));
        keys.add(new AccountMeta(SystemProgram.PROGRAM_ID, false, false));
        ByteBuffer data = ByteBuffer.allocate(12 + addresses.size() * 32);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.putInt(2);
        data.putLong(addresses.size());
        for (PublicKey address : addresses) {
            data.put(address.toByteArray());
        }
        return AddressLookupTableProgram.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction deactivateLookupTable(PublicKey lookupTable, PublicKey authority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(lookupTable, false, true));
        keys.add(new AccountMeta(authority, true, false));
        ByteBuffer data = ByteBuffer.allocate(1);
        data.put((byte)3);
        return AddressLookupTableProgram.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction closeLookupTable(PublicKey lookupTable, PublicKey authority, PublicKey recipient) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(lookupTable, false, true));
        keys.add(new AccountMeta(authority, true, false));
        keys.add(new AccountMeta(recipient, false, true));
        ByteBuffer data = ByteBuffer.allocate(1);
        data.put((byte)4);
        return AddressLookupTableProgram.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }
}

