/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;
import org.p2p.solanaj.programs.SystemProgram;
import org.p2p.solanaj.programs.TokenProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociatedTokenProgram
extends Program {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssociatedTokenProgram.class);
    public static final PublicKey PROGRAM_ID = new PublicKey("ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL");
    private static final int CREATE_METHOD_ID = 0;
    private static final int CREATE_IDEMPOTENT_METHOD_ID = 1;
    private static final int RECOVER_NESTED_METHOD_ID = 2;

    public static TransactionInstruction create(PublicKey fundingAccount, PublicKey walletAddress, PublicKey mint) {
        return AssociatedTokenProgram.createInstruction(0, fundingAccount, walletAddress, mint);
    }

    public static TransactionInstruction createIdempotent(PublicKey fundingAccount, PublicKey walletAddress, PublicKey mint) {
        return AssociatedTokenProgram.createInstruction(1, fundingAccount, walletAddress, mint);
    }

    public static TransactionInstruction recoverNested(PublicKey nestedAccount, PublicKey nestedMint, PublicKey destinationAccount, PublicKey ownerAccount, PublicKey ownerMint, PublicKey wallet) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(nestedAccount, false, true));
        keys.add(new AccountMeta(nestedMint, false, false));
        keys.add(new AccountMeta(destinationAccount, false, true));
        keys.add(new AccountMeta(ownerAccount, false, false));
        keys.add(new AccountMeta(ownerMint, false, false));
        keys.add(new AccountMeta(wallet, true, true));
        keys.add(new AccountMeta(TokenProgram.PROGRAM_ID, false, false));
        byte[] transactionData = AssociatedTokenProgram.encodeInstructionData(2);
        return AssociatedTokenProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    private static TransactionInstruction createInstruction(int methodId, PublicKey fundingAccount, PublicKey walletAddress, PublicKey mint) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        PublicKey pda = AssociatedTokenProgram.findAssociatedTokenAddress(walletAddress, mint);
        keys.add(new AccountMeta(fundingAccount, true, true));
        keys.add(new AccountMeta(pda, false, true));
        keys.add(new AccountMeta(walletAddress, false, false));
        keys.add(new AccountMeta(mint, false, false));
        keys.add(new AccountMeta(SystemProgram.PROGRAM_ID, false, false));
        keys.add(new AccountMeta(TokenProgram.PROGRAM_ID, false, false));
        byte[] transactionData = AssociatedTokenProgram.encodeInstructionData(methodId);
        return AssociatedTokenProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    private static PublicKey findAssociatedTokenAddress(PublicKey walletAddress, PublicKey mint) {
        try {
            PublicKey pda = PublicKey.findProgramAddress(List.of(walletAddress.toByteArray(), TokenProgram.PROGRAM_ID.toByteArray(), mint.toByteArray()), PROGRAM_ID).getAddress();
            log.info("ATA: {}", (Object)pda.toBase58());
            return pda;
        }
        catch (Exception e) {
            log.error("Error finding ATA: {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to find associated token address", e);
        }
    }

    private static byte[] encodeInstructionData(int methodId) {
        ByteBuffer result = ByteBuffer.allocate(1);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)methodId);
        return result.array();
    }
}

