/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import org.p2p.solanaj.rpc.Cluster;
import org.p2p.solanaj.rpc.RpcApi;
import org.p2p.solanaj.rpc.RpcException;
import org.p2p.solanaj.rpc.WeightedCluster;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.RpcResponse;
import org.p2p.solanaj.rpc.types.WeightedEndpoint;

public class RpcClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String endpoint;
    private OkHttpClient httpClient;
    private RpcApi rpcApi;
    private WeightedCluster cluster;
    private final Moshi moshi;

    private static OkHttpClient.Builder createOptimizedClientBuilder() {
        return new OkHttpClient.Builder().protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
    }

    public RpcClient(WeightedCluster cluster) {
        this.cluster = cluster;
        this.endpoint = cluster.getEndpoints().get(0).getUrl();
        this.httpClient = RpcClient.createOptimizedClientBuilder().readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.moshi = new Moshi.Builder().build();
    }

    public RpcClient(Cluster endpoint) {
        this(endpoint.getEndpoint());
    }

    public RpcClient(String endpoint) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().readTimeout(20L, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, String userAgent) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().addNetworkInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", userAgent).build();
            return chain.proceed(requestWithUserAgent);
        }).readTimeout(20L, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, int timeout) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().readTimeout((long)timeout, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, int readTimeoutMs, int connectTimeoutMs, int writeTimeoutMs) {
        this.endpoint = endpoint;
        this.httpClient = RpcClient.createOptimizedClientBuilder().readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.moshi = new Moshi.Builder().build();
    }

    public RpcClient(String endpoint, OkHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.rpcApi = new RpcApi(this);
        this.moshi = new Moshi.Builder().build();
    }

    public RpcClient(String endpoint, String proxyHost, int proxyPort) {
        this.endpoint = endpoint;
        this.httpClient = RpcClient.createOptimizedClientBuilder().proxy(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHost, proxyPort))).readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.moshi = new Moshi.Builder().build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T call(String method, List<Object> params, Class<T> clazz) throws RpcException {
        RpcRequest rpcRequest = new RpcRequest(method, params);
        JsonAdapter rpcRequestJsonAdapter = this.moshi.adapter(RpcRequest.class);
        JsonAdapter resultAdapter = this.moshi.adapter((Type)Types.newParameterizedType(RpcResponse.class, (Type[])new Type[]{clazz}));
        Request request = new Request.Builder().url(this.getEndpoint()).header("Accept-Encoding", "gzip, deflate").post(RequestBody.create((String)rpcRequestJsonAdapter.toJson((Object)rpcRequest), (MediaType)JSON)).build();
        try {
            String result;
            Response response = this.httpClient.newCall(request).execute();
            String contentEncoding = response.header("Content-Encoding");
            if ("gzip".equals(contentEncoding)) {
                try (GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(response.body().bytes()));){
                    result = new String(gzipStream.readAllBytes());
                }
            } else {
                result = response.body().string();
            }
            try (Buffer buffer = new Buffer().writeUtf8(result);){
                JsonReader reader = JsonReader.of((BufferedSource)buffer);
                reader.setLenient(true);
                RpcResponse rpcResult = (RpcResponse)resultAdapter.fromJson(reader);
                if (rpcResult == null || rpcResult.getError() != null) {
                    String string;
                    if (rpcResult != null) {
                        string = rpcResult.getError().getMessage();
                        throw new RpcException(string);
                    }
                    string = "RPC response is null";
                    throw new RpcException(string);
                }
                Object t = rpcResult.getResult();
                return t;
            }
        }
        catch (SSLHandshakeException e) {
            this.httpClient = RpcClient.createOptimizedClientBuilder().build();
            throw new RpcException("SSL Handshake failed: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RpcException("IO error during RPC call: " + e.getMessage());
        }
    }

    public RpcApi getApi() {
        return this.rpcApi;
    }

    public String getEndpoint() {
        return this.cluster != null ? this.getWeightedEndpoint() : this.endpoint;
    }

    private String getWeightedEndpoint() {
        int totalWeight = this.cluster.endpoints.stream().mapToInt(WeightedEndpoint::getWeight).sum();
        double randomNumber = Math.random() * (double)totalWeight;
        int currentWeight = 0;
        for (WeightedEndpoint endpoint : this.cluster.endpoints) {
            if (!(randomNumber < (double)(currentWeight += endpoint.getWeight().intValue()))) continue;
            return endpoint.getUrl();
        }
        return "";
    }
}

