/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.token;

import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.Transaction;
import org.p2p.solanaj.programs.MemoProgram;
import org.p2p.solanaj.programs.TokenProgram;
import org.p2p.solanaj.rpc.RpcClient;
import org.p2p.solanaj.rpc.RpcException;

public class TokenManager {
    private final RpcClient client;

    public TokenManager(RpcClient client) {
        this.client = client;
    }

    public String transfer(Account owner, PublicKey source, PublicKey destination, PublicKey tokenMint, long amount) {
        Transaction transaction = new Transaction();
        transaction.addInstruction(TokenProgram.transfer(source, destination, amount, owner.getPublicKey()));
        transaction.addInstruction(MemoProgram.writeUtf8(owner.getPublicKey(), "Hello from SolanaJ"));
        String result = null;
        try {
            result = this.client.getApi().sendTransaction(transaction, owner);
        }
        catch (RpcException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String transferCheckedToSolAddress(Account owner, PublicKey source, PublicKey destination, PublicKey tokenMint, long amount, byte decimals) {
        PublicKey tokenAccount = null;
        try {
            tokenAccount = this.client.getApi().getTokenAccountsByOwner(destination, tokenMint);
        }
        catch (RpcException e) {
            e.printStackTrace();
        }
        Transaction transaction = new Transaction();
        transaction.addInstruction(TokenProgram.transferChecked(source, tokenAccount, amount, decimals, owner.getPublicKey(), tokenMint));
        transaction.addInstruction(MemoProgram.writeUtf8(owner.getPublicKey(), "Hello from SolanaJ"));
        String result = null;
        try {
            result = this.client.getApi().sendTransaction(transaction, owner);
        }
        catch (RpcException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String initializeAccount(Account newAccount, PublicKey usdcTokenMint, Account owner) {
        Transaction transaction = new Transaction();
        transaction.addInstruction(TokenProgram.initializeAccount(newAccount.getPublicKey(), usdcTokenMint, owner.getPublicKey()));
        String result = null;
        try {
            result = this.client.getApi().sendTransaction(transaction, owner);
        }
        catch (RpcException e) {
            e.printStackTrace();
        }
        return result;
    }
}

