/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.TempFileProvider;
import com.platon.codegen.FunctionWrapperGenerator;
import com.platon.codegen.SolidityFunctionWrapperGenerator;
import com.platon.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SolidityFunctionWrapperGeneratorTest
extends TempFileProvider {
    private String solidityBaseDir;

    public void setUp() throws Exception {
        super.setUp();
        URL url = SolidityFunctionWrapperGeneratorTest.class.getClassLoader().getResource("solidity");
        this.solidityBaseDir = url.getPath();
    }

    @Test
    public void testDelegate() throws Exception {
        this.testCodeGenerationJvmTypes("delegate", "ProxyDelegate");
        this.testCodeGenerationSolidityTypes("delegate", "ProxyDelegate");
    }

    @Test
    public void testPramaAndReturns() throws Exception {
        this.testCodeGenerationJvmTypes("pramaAndReturns", "PramaAndReturns");
        this.testCodeGenerationSolidityTypes("pramaAndReturns", "PramaAndReturns");
    }

    @Test
    public void testGetFileNoExtension() {
        Assert.assertThat((Object)FunctionWrapperGenerator.getFileNameNoExtension((String)""), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)FunctionWrapperGenerator.getFileNameNoExtension((String)"file"), (Matcher)Is.is((Object)"file"));
        Assert.assertThat((Object)FunctionWrapperGenerator.getFileNameNoExtension((String)"file."), (Matcher)Is.is((Object)"file"));
        Assert.assertThat((Object)FunctionWrapperGenerator.getFileNameNoExtension((String)"file.txt"), (Matcher)Is.is((Object)"file"));
    }

    @Test
    public void testHumanStandardTokenGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("humanStandardToken", "HumanStandardToken");
    }

    @Test
    public void testSolEventGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("solEvent", "SolEvent");
    }

    @Test
    public void testGreeterGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("greeter", "Greeter");
        this.testCodeGenerationSolidityTypes("greeter", "Greeter");
    }

    @Test
    public void testSimpleStorageGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("simplestorage", "SimpleStorage");
        this.testCodeGenerationSolidityTypes("simplestorage", "SimpleStorage");
    }

    @Test
    public void testFibonacciGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("fibonacci", "Fibonacci");
        this.testCodeGenerationSolidityTypes("fibonacci", "Fibonacci");
    }

    @Test
    public void testArrays() throws Exception {
        this.testCodeGenerationJvmTypes("arrays", "Arrays");
        this.testCodeGenerationSolidityTypes("arrays", "Arrays");
    }

    @Test
    public void testShipIt() throws Exception {
        this.testCodeGenerationJvmTypes("shipit", "ShipIt");
        this.testCodeGenerationSolidityTypes("shipit", "ShipIt");
    }

    private void testCodeGenerationJvmTypes(String contractName, String inputFileName) throws Exception {
        this.testCodeGeneration(contractName, inputFileName, "org.web3j.unittests.java", "--javaTypes");
    }

    private void testCodeGenerationSolidityTypes(String contractName, String inputFileName) throws Exception {
        this.testCodeGeneration(contractName, inputFileName, "org.web3j.unittests.solidity", "--solidityTypes");
    }

    private void testCodeGeneration(String contractName, String inputFileName, String packageName, String types) throws Exception {
        SolidityFunctionWrapperGenerator.main((String[])Arrays.asList(types, this.solidityBaseDir + File.separator + contractName + File.separator + "build" + File.separator + inputFileName + ".bin", this.solidityBaseDir + File.separator + contractName + File.separator + "build" + File.separator + inputFileName + ".abi", "-p", packageName, "-o", this.tempDirPath).toArray(new String[0]));
        this.verifyGeneratedCode(this.tempDirPath + File.separator + packageName.replace('.', File.separatorChar) + File.separator + Strings.capitaliseFirstLetter((String)inputFileName) + ".java");
    }

    private void verifyGeneratedCode(String sourceFile) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Arrays.asList(sourceFile));
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            boolean result = task.call();
            System.out.println(diagnostics.getDiagnostics());
            Assert.assertTrue((String)"Generated contract contains compile time error", (boolean)result);
        }
    }
}

