/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.TempFileProvider;
import com.platon.codegen.ContractJsonParseTest;
import com.platon.codegen.SolidityFunctionWrapperGeneratorTest;
import com.platon.codegen.TruffleJsonFunctionWrapperGenerator;
import com.platon.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TruffleJsonFunctionWrapperGeneratorTest
extends TempFileProvider {
    private static final String PackageName = "org.web3j.unittests.truffle.java";
    private String contractBaseDir;

    private static void verifyGeneratedCode(String sourceFile) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(sourceFile));
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            Assert.assertTrue((String)"Generated contract contains compile time error", (boolean)task.call());
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        URL url = SolidityFunctionWrapperGeneratorTest.class.getClassLoader().getResource("truffle");
        this.contractBaseDir = url.getPath();
    }

    @Test
    public void testLibGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("MetaCoin", "ConvertLib");
        this.testCodeGenerationSolidtyTypes("MetaCoin", "ConvertLib");
    }

    @Test
    public void testContractGeneration() throws Exception {
        this.testCodeGenerationJvmTypes("MetaCoin", "MetaCoin");
        this.testCodeGenerationSolidtyTypes("MetaCoin", "MetaCoin");
    }

    private void testCodeGenerationJvmTypes(String contractName, String inputFileName) throws Exception {
        this.testCodeGeneration(contractName, inputFileName, PackageName, "--javaTypes");
    }

    private void testCodeGenerationSolidtyTypes(String contractName, String inputFileName) throws Exception {
        this.testCodeGeneration(contractName, inputFileName, PackageName, "--solidityTypes");
    }

    private void testCodeGeneration(String contractName, String inputFileName, String packageName, String types) throws Exception {
        TruffleJsonFunctionWrapperGenerator.main((String[])Arrays.asList(types, ContractJsonParseTest.jsonFileLocation(this.contractBaseDir, contractName, inputFileName), "-p", packageName, "-o", this.tempDirPath).toArray(new String[0]));
        TruffleJsonFunctionWrapperGeneratorTest.verifyGeneratedCode(this.tempDirPath + File.separator + packageName.replace('.', File.separatorChar) + File.separator + Strings.capitaliseFirstLetter((String)inputFileName) + ".java");
    }
}

