/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.platon.protocol.ObjectMapperFactory;
import com.platon.protocol.Web3jService;
import com.platon.protocol.core.Request;
import com.platon.protocol.core.Response;
import com.platon.protocol.websocket.events.Notification;
import com.platon.utils.Async;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import rx.Observable;

public abstract class Service
implements Web3jService {
    protected final ObjectMapper objectMapper;

    public Service(boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    protected abstract InputStream performIO(String var1) throws IOException;

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                Response response = (Response)this.objectMapper.readValue(result, responseType);
                return (T)response;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request jsonRpc20Request, Class<T> responseType) {
        return Async.run(() -> this.send(jsonRpc20Request, responseType));
    }

    @Override
    public <T extends Notification<?>> Observable<T> subscribe(Request request, String unsubscribeMethod, Class<T> responseType) {
        throw new UnsupportedOperationException(String.format("Service %s does not support subscriptions", this.getClass().getSimpleName()));
    }
}

