/*
 * Decompiled with CFR 0.152.
 */
package com.platon.tx;

import com.platon.protocol.Web3j;
import com.platon.protocol.core.methods.response.PlatonGasPrice;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.tx.TransactionManager;
import java.io.IOException;
import java.math.BigInteger;

public abstract class ManagedTransaction {
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(22000000000L);
    protected Web3j web3j;
    protected TransactionManager transactionManager;

    protected ManagedTransaction(Web3j web3j, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.web3j = web3j;
    }

    public BigInteger requestCurrentGasPrice() throws IOException {
        PlatonGasPrice ethGasPrice = this.web3j.platonGasPrice().send();
        return ethGasPrice.getGasPrice();
    }

    protected TransactionReceipt send(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit) throws IOException, TransactionException {
        return this.transactionManager.executeTransaction(gasPrice, gasLimit, to, data, value);
    }

    protected TransactionReceipt getTransactionReceipt(PlatonSendTransaction ethSendTransaction) throws IOException, TransactionException {
        return this.transactionManager.getTransactionReceipt(ethSendTransaction);
    }

    protected PlatonSendTransaction sendPlatonRawTransaction(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit) throws IOException {
        return this.transactionManager.sendTransaction(gasPrice, gasLimit, to, data, value);
    }
}

