/*
 * Decompiled with CFR 0.152.
 */
package com.platon.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    private static SerializeConfig serializeConfig;
    private static final SerializerFeature[] serializerFeature;

    private JSONUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        Object t = null;
        try {
            t = JSON.parseObject((String)text, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> T parseObject(Map<String, String> map, Class<T> clazz) {
        Object t = null;
        try {
            t = JSON.parseObject((String)JSONUtil.toJSONString(map), clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        List list = new ArrayList();
        try {
            list = JSON.parseArray((String)text, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String toJSONString(Object object) {
        String json = "";
        try {
            json = JSON.toJSONString((Object)object, (SerializeConfig)serializeConfig, (SerializerFeature[])serializerFeature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String toJSONString(Map<String, String> params) {
        JSONObject jsonObject = new JSONObject();
        if (params == null || params.isEmpty()) {
            return jsonObject.toString();
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return jsonObject.toString();
    }

    public static Map<String, Object> jsonToMap(String json) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            result = (Map)JSON.parse((String)json, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static <T> Map<String, Object> beanToMap(T t) {
        return JSONUtil.jsonToMap(JSONUtil.toJSONString(t));
    }

    static {
        serializerFeature = new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
        serializeConfig = new SerializeConfig();
    }
}

