/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;

final class FieldReaderFloatValueFunc<T>
extends FieldReaderImpl<T> {
    final Method method;
    final ObjFloatConsumer<T> function;

    public FieldReaderFloatValueFunc(String fieldName, int ordinal, Float defaultValue, JSONSchema schema, Method method, ObjFloatConsumer<T> function) {
        super(fieldName, Float.TYPE, Float.TYPE, ordinal, 0L, null, null, defaultValue, schema);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, float value) {
        if (this.schema != null) {
            this.schema.assertValidate((double)value);
        }
        this.function.accept(object, value);
    }

    @Override
    public void accept(T object, Object value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.method.invoke(object, Float.valueOf(TypeUtils.toFloatValue(value)));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        float fieldValue = jsonReader.readFloatValue();
        if (this.schema != null) {
            this.schema.assertValidate((double)fieldValue);
        }
        this.function.accept(object, fieldValue);
    }
}

