/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class BeanUtils {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    static ConcurrentMap<Class, Field[]> fieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Map<String, Field>> fieldMapCache = new ConcurrentHashMap<Class, Map<String, Field>>();
    static ConcurrentMap<Class, Field[]> declaredFieldCache = new ConcurrentHashMap<Class, Field[]>();
    static ConcurrentMap<Class, Method[]> methodCache = new ConcurrentHashMap<Class, Method[]>();
    static ConcurrentMap<Class, Constructor[]> constructorCache = new ConcurrentHashMap<Class, Constructor[]>();
    private static volatile Class RECORD_CLASS;
    private static volatile Method RECORD_GET_RECORD_COMPONENTS;
    private static volatile Method RECORD_COMPONENT_GET_NAME;
    private static volatile Method RECORD_COMPONENT_GET_TYPE;
    private static volatile boolean kotlin_class_klass_error;
    private static volatile Constructor kotlin_kclass_constructor;
    private static volatile Method kotlin_kclass_getConstructors;
    private static volatile Method kotlin_kfunction_getParameters;
    private static volatile Method kotlin_kparameter_getName;
    private static volatile boolean kotlin_error;

    public static String[] getRecordFieldNames(Class<?> recordType) {
        if (JDKUtils.JVM_VERSION < 14) {
            return new String[0];
        }
        try {
            if (RECORD_GET_RECORD_COMPONENTS == null) {
                RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
            }
            if (RECORD_COMPONENT_GET_NAME == null) {
                Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
                RECORD_COMPONENT_GET_NAME = c.getMethod("getName", new Class[0]);
                RECORD_COMPONENT_GET_TYPE = c.getMethod("getType", new Class[0]);
            }
            Object[] components = (Object[])RECORD_GET_RECORD_COMPONENTS.invoke(recordType, new Object[0]);
            String[] names = new String[components.length];
            for (int i = 0; i < components.length; ++i) {
                names[i] = (String)RECORD_COMPONENT_GET_NAME.invoke(components[i], new Object[0]);
            }
            return names;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", e.getClass().getName(), e.getMessage()), e);
        }
    }

    public static Constructor getKotlinConstructor(Class objectClass, String[] paramNames) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        Constructor creatorConstructor = null;
        for (Constructor constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (paramNames != null && parameterTypes.length != paramNames.length || parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || creatorConstructor != null && creatorConstructor.getParameterTypes().length >= parameterTypes.length) continue;
            creatorConstructor = constructor;
        }
        return creatorConstructor;
    }

    public static String[] getKotlinConstructorParameters(Class clazz) {
        Class<?> class_kotlin_kclass;
        if (kotlin_kclass_constructor == null && !kotlin_class_klass_error) {
            try {
                class_kotlin_kclass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_constructor = class_kotlin_kclass.getConstructor(Class.class);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kclass_constructor == null) {
            return null;
        }
        if (kotlin_kclass_getConstructors == null && !kotlin_class_klass_error) {
            try {
                class_kotlin_kclass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_getConstructors = class_kotlin_kclass.getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kfunction_getParameters == null && !kotlin_class_klass_error) {
            try {
                Class<?> class_kotlin_kfunction = Class.forName("kotlin.reflect.KFunction");
                kotlin_kfunction_getParameters = class_kotlin_kfunction.getMethod("getParameters", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kparameter_getName == null && !kotlin_class_klass_error) {
            try {
                Class<?> class_kotlinn_kparameter = Class.forName("kotlin.reflect.KParameter");
                kotlin_kparameter_getName = class_kotlinn_kparameter.getMethod("getName", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_error) {
            return null;
        }
        try {
            Object constructor = null;
            Object kclassImpl = kotlin_kclass_constructor.newInstance(clazz);
            Iterable it = (Iterable)kotlin_kclass_getConstructors.invoke(kclassImpl, new Object[0]);
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                List parameters = (List)kotlin_kfunction_getParameters.invoke(item, new Object[0]);
                if (constructor == null || parameters.size() != 0) {
                    constructor = item;
                }
                iterator.hasNext();
            }
            if (constructor == null) {
                return null;
            }
            List parameters = (List)kotlin_kfunction_getParameters.invoke(constructor, new Object[0]);
            String[] names = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Object param = parameters.get(i);
                names[i] = (String)kotlin_kparameter_getName.invoke(param, new Object[0]);
            }
            return names;
        }
        catch (Throwable e) {
            e.printStackTrace();
            kotlin_error = true;
            return null;
        }
    }

    public static void fields(Class objectClass, Consumer<Field> fieldReaders) {
        Field[] fields = (Field[])fieldCache.get(objectClass);
        if (fields == null) {
            fields = objectClass.getFields();
            fieldCache.putIfAbsent(objectClass, fields);
        }
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            fieldReaders.accept(field);
        }
    }

    public static Field getDeclaredField(Class objectClass, String fieldName) {
        Map fieldMap = (Map)fieldMapCache.get(objectClass);
        if (fieldMap == null) {
            HashMap map = new HashMap();
            BeanUtils.declaredFields(objectClass, field -> map.put(field.getName(), field));
            fieldMapCache.putIfAbsent(objectClass, map);
            fieldMap = (Map)fieldMapCache.get(objectClass);
        }
        return (Field)fieldMap.get(fieldName);
    }

    public static void declaredFields(Class objectClass, Consumer<Field> fieldConsumer) {
        Field[] fields;
        Class superclass = objectClass.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            BeanUtils.declaredFields(superclass, fieldConsumer);
        }
        if ((fields = (Field[])declaredFieldCache.get(objectClass)) == null) {
            Field[] declaredFields = objectClass.getDeclaredFields();
            boolean allMatch = true;
            for (Field field : declaredFields) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                fields = declaredFields;
            } else {
                ArrayList<Field> list = new ArrayList<Field>(declaredFields.length);
                for (Field field : declaredFields) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers)) continue;
                    list.add(field);
                }
                fields = list.toArray(new Field[list.size()]);
            }
            fieldCache.putIfAbsent(objectClass, fields);
        }
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            fieldConsumer.accept(field);
        }
    }

    public static void staticMethod(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            methodConsumer.accept(method);
        }
    }

    public static Method buildMethod(Class objectClass, String methodName) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || method.getParameterCount() != 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static void constructor(Class objectClass, Consumer<Constructor> constructorConsumer) {
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            constructorConsumer.accept(constructor);
        }
    }

    public static Constructor getDefaultConstructor(Class objectClass) {
        if (objectClass == StackTraceElement.class && JDKUtils.JVM_VERSION >= 9) {
            return null;
        }
        Constructor[] constructors = (Constructor[])constructorCache.get(objectClass);
        if (constructors == null) {
            constructors = objectClass.getDeclaredConstructors();
            constructorCache.putIfAbsent(objectClass, constructors);
        }
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static void setters(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramCount = method.getParameterCount();
            if (paramCount == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || returnType == AtomicReference.class || Collection.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramCount == 2 && method.getReturnType() == Void.TYPE && method.getParameterTypes()[0] == String.class) {
                Annotation[] annotations = method.getAnnotations();
                boolean unwrapped = false;
                block7: for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (annotationType == JSONField.class) {
                        if (!((JSONField)annotation).unwrapped()) continue;
                        unwrapped = true;
                        break;
                    }
                    switch (annotationType.getName()) {
                        case "com.fasterxml.jackson.annotation.JsonAnySetter": {
                            unwrapped = true;
                            continue block7;
                        }
                    }
                }
                if (!unwrapped) continue;
                methodConsumer.accept(method);
                continue;
            }
            if (paramCount != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void setters(Class objectClass, boolean checkPrefix, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            String methodName;
            int methodNameLength;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType == 0) {
                String methodName2 = method.getName();
                if (methodName2.length() <= 3 || checkPrefix && !methodName2.startsWith("get")) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == AtomicInteger.class || returnType == AtomicLong.class || returnType == AtomicBoolean.class || returnType == AtomicIntegerArray.class || returnType == AtomicLongArray.class || Collection.class.isAssignableFrom(returnType)) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            if (paramType != 1 || Modifier.isStatic(mods = method.getModifiers()) || (methodNameLength = (methodName = method.getName()).length()) <= 3 || checkPrefix && !methodName.startsWith("set")) continue;
            methodConsumer.accept(method);
        }
    }

    public static void annotationMethods(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods = (Method[])methodCache.get(objectClass);
        if (methods == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        block12: for (Method method : methods) {
            if (method.getParameterCount() != 0) continue;
            switch (method.getName()) {
                case "toString": 
                case "hashCode": 
                case "annotationType": 
                case "wait": 
                case "notify": 
                case "notifyAll": 
                case "getClass": {
                    continue block12;
                }
                default: {
                    methodConsumer.accept(method);
                }
            }
        }
    }

    public static Member getEnumValueField(Class clazz) {
        if (clazz == null) {
            return null;
        }
        AccessibleObject member = null;
        Method[] methods = (Method[])methodCache.get(clazz);
        if (methods == null) {
            methods = clazz.getMethods();
            methodCache.putIfAbsent(clazz, methods);
        }
        for (Method method : methods) {
            Annotation[] annotations;
            if (method.getReturnType() == Void.class) continue;
            block16: for (Annotation annotation : annotations = method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONField": 
                    case "com.alibaba.fastjson2.annotation.JSONField": 
                    case "com.fasterxml.jackson.annotation.JsonValue": {
                        member = method;
                        continue block16;
                    }
                }
            }
        }
        Field[] fields = (Field[])fieldCache.get(clazz);
        if (fields == null) {
            fields = clazz.getFields();
            fieldCache.putIfAbsent(clazz, fields);
        }
        for (Field field : fields) {
            Annotation[] annotations;
            block18: for (Annotation annotation : annotations = field.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONField": 
                    case "com.alibaba.fastjson.annotation2.JSONField": {
                        member = field;
                        continue block18;
                    }
                }
            }
        }
        return member;
    }

    public static boolean hasStaticCreatorOrBuilder(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Method[] methods = (Method[])methodCache.get(clazz);
        if (methods == null) {
            methods = clazz.getMethods();
            methodCache.putIfAbsent(clazz, methods);
        }
        for (Method method : methods) {
            Annotation[] annotations;
            if (!Modifier.isStatic(method.getModifiers()) || method.getReturnType() == Void.class) continue;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONCreator": 
                    case "com.alibaba.fastjson2.annotation.JSONCreator": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void getters(Class objectClass, Consumer<Method> methodConsumer) {
        Method[] methods;
        Class<?>[] interfaces;
        if (Proxy.isProxyClass(objectClass) && (interfaces = objectClass.getInterfaces()).length == 1) {
            BeanUtils.getters(interfaces[0], methodConsumer);
            return;
        }
        boolean record = BeanUtils.isRecord(objectClass);
        String[] recordFieldNames = null;
        if (record) {
            recordFieldNames = BeanUtils.getRecordFieldNames(objectClass);
        }
        if ((methods = (Method[])methodCache.get(objectClass)) == null) {
            methods = objectClass.getMethods();
            methodCache.putIfAbsent(objectClass, methods);
        }
        for (Method method : methods) {
            char firstChar;
            boolean nameMatch;
            Class<?> declaringClass;
            Class<?> returnClass;
            int mods;
            int paramType = method.getParameterCount();
            if (paramType != 0 || Modifier.isStatic(mods = method.getModifiers()) || (returnClass = method.getReturnType()) == Void.class || (declaringClass = method.getDeclaringClass()) == Enum.class) continue;
            String methodName = method.getName();
            if (record) {
                boolean match = false;
                for (String recordFieldName : recordFieldNames) {
                    if (!methodName.equals(recordFieldName)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    methodConsumer.accept(method);
                    continue;
                }
            }
            int methodNameLength = methodName.length();
            if (returnClass == Boolean.TYPE) {
                boolean bl = nameMatch = methodName.startsWith("is") && methodNameLength > 2;
                if (nameMatch && (firstChar = methodName.charAt(2)) >= 'a' && firstChar <= 'z' && methodNameLength == 3) {
                    nameMatch = false;
                }
            } else {
                boolean bl = nameMatch = methodName.startsWith("get") && methodNameLength > 3;
                if (nameMatch && (firstChar = methodName.charAt(3)) >= 'a' && firstChar <= 'z' && methodNameLength == 4) {
                    nameMatch = false;
                }
            }
            if (!nameMatch || returnClass == Class.class && "getClass".equals(methodName)) continue;
            methodConsumer.accept(method);
        }
    }

    public static boolean isRecord(Class objectClass) {
        Class superclass = objectClass.getSuperclass();
        if (superclass == null) {
            return false;
        }
        if (RECORD_CLASS == null) {
            String superclassName = superclass.getName();
            return "java.lang.Record".equals(superclassName);
        }
        return superclass == RECORD_CLASS;
    }

    public static String setterName(String methodName) {
        return BeanUtils.setterName(methodName, null);
    }

    public static String setterName(String methodName, String namingStrategy) {
        int methodNameLength;
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        if ((methodNameLength = methodName.length()) <= 3) {
            return methodName;
        }
        int prefixLength = methodName.startsWith("set") ? 3 : 0;
        switch (namingStrategy) {
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
                if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, prefixLength);
            }
            case "UpperCase": {
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                for (int i = 0; i < chars.length; ++i) {
                    char ch = chars[i];
                    if (ch < 'a' || c0 > 'z') continue;
                    chars[i] = (char)(ch - 32);
                }
                return new String(chars);
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    public static String setterName(String methodName, int prefixLength) {
        boolean c1UCase;
        int methodNameLength = methodName.length();
        char[] chars = new char[methodNameLength - prefixLength];
        methodName.getChars(prefixLength, methodNameLength, chars, 0);
        char c0 = chars[0];
        boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
        if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
            chars[0] = (char)(c0 + 32);
        }
        return new String(chars);
    }

    public static String getterName(String methodName, String namingStrategy) {
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        int methodNameLength = methodName.length();
        boolean is = methodName.startsWith("is");
        boolean get = methodName.startsWith("get");
        int prefixLength = is ? 2 : (get ? 3 : 0);
        switch (namingStrategy) {
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'A' && chars[1] <= 'Z';
                if (c0 >= 'A' && c0 <= 'Z' && !c1UCase) {
                    chars[0] = (char)(c0 + 32);
                }
                return new String(chars);
            }
            case "PascalCase": {
                boolean c1UCase;
                char[] chars = new char[methodNameLength - prefixLength];
                methodName.getChars(prefixLength, methodNameLength, chars, 0);
                char c0 = chars[0];
                boolean bl = c1UCase = chars.length > 1 && chars[1] >= 'a' && chars[1] <= 'z';
                if (c0 >= 'a' && c0 <= 'z' && !c1UCase) {
                    chars[0] = (char)(c0 - 32);
                }
                return new String(chars);
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, prefixLength);
            }
            case "UpperCase": {
                return methodName.substring(prefixLength).toUpperCase();
            }
            case "KebabCase": {
                StringBuilder buf = new StringBuilder();
                int firstIndex = is ? 2 : (get ? 3 : 0);
                for (int i = firstIndex; i < methodName.length(); ++i) {
                    char ch = methodName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char ch_ucase = (char)(ch + 32);
                        if (i > firstIndex) {
                            buf.append('-');
                        }
                        buf.append(ch_ucase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    public static String fieldName(String methodName, String namingStrategy) {
        if (namingStrategy == null) {
            namingStrategy = "CamelCase";
        }
        switch (namingStrategy) {
            case "NeverUseThisValueExceptDefaultValue": 
            case "CamelCase": {
                char c1;
                char c0 = methodName.charAt(0);
                if (c0 >= 'A' && c0 <= 'Z' && methodName.length() > 1 && (c1 = methodName.charAt(1)) >= 'A' && c1 <= 'Z') {
                    char[] chars = methodName.toCharArray();
                    chars[0] = (char)(c0 + 32);
                    return new String(chars);
                }
                return methodName;
            }
            case "PascalCase": {
                char c1;
                char c0 = methodName.charAt(0);
                if (c0 >= 'a' && c0 <= 'z' && methodName.length() > 1 && (c1 = methodName.charAt(1)) >= 'a' && c1 <= 'z') {
                    char[] chars = methodName.toCharArray();
                    chars[0] = (char)(c0 - 32);
                    return new String(chars);
                }
                return methodName;
            }
            case "SnakeCase": {
                return BeanUtils.snakeCase(methodName, 0);
            }
            case "UpperCase": {
                return methodName.toUpperCase();
            }
            case "KebabCase": {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < methodName.length(); ++i) {
                    char ch = methodName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char ch_ucase = (char)(ch + 32);
                        if (i > 0) {
                            buf.append('-');
                        }
                        buf.append(ch_ucase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
        }
        throw new JSONException("TODO : " + namingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String snakeCase(String methodName, int prefixLength) {
        int methodNameLength = methodName.length();
        char[] buf = TypeUtils.CHARS_UPDATER.getAndSet(TypeUtils.CACHE, null);
        if (buf == null) {
            buf = new char[128];
        }
        try {
            int off = 0;
            for (int i = prefixLength; i < methodNameLength; ++i) {
                char ch = methodName.charAt(i);
                if (ch >= 'A' && ch <= 'Z') {
                    char ch_ucase = (char)(ch + 32);
                    if (i > prefixLength) {
                        buf[off++] = 95;
                    }
                    buf[off++] = ch_ucase;
                    continue;
                }
                buf[off++] = ch;
            }
            String string = new String(buf, 0, off);
            return string;
        }
        finally {
            TypeUtils.CHARS_UPDATER.set(TypeUtils.CACHE, buf);
        }
    }

    public static Type getFieldType(TypeReference type, Class<?> raw, Member field, Type fieldType) {
        Class<?> declaringClass = field.getDeclaringClass();
        while (raw != Object.class) {
            if (declaringClass == raw) {
                return BeanUtils.resolve(type.getType(), declaringClass, fieldType);
            }
            type = TypeReference.get(BeanUtils.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return null;
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] upperBounds = bound instanceof WildcardType ? ((WildcardType)bound).getUpperBounds() : new Type[]{bound};
        return new WildcardTypeImpl(upperBounds, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] lowerBounds = bound instanceof WildcardType ? ((WildcardType)bound).getLowerBounds() : new Type[]{bound};
        return new WildcardTypeImpl(new Type[]{Object.class}, lowerBounds);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(BeanUtils.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            BeanUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(BeanUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return BeanUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return BeanUtils.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return BeanUtils.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return BeanUtils.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return BeanUtils.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        return BeanUtils.resolve(context, contextRawType, toResolve, new HashMap());
    }

    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Map<TypeVariable<?>, Type> visitedTypeVariables) {
        TypeVariable resolving;
        block17: {
            Class<?> componentType;
            Type original;
            resolving = null;
            while (toResolve instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)toResolve;
                Type previouslyResolved = visitedTypeVariables.get(typeVariable);
                if (previouslyResolved != null) {
                    return previouslyResolved == Void.TYPE ? toResolve : previouslyResolved;
                }
                visitedTypeVariables.put(typeVariable, Void.TYPE);
                if (resolving == null) {
                    resolving = typeVariable;
                }
                if ((toResolve = BeanUtils.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
                break block17;
            }
            if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
                Type newComponentType;
                original = (Class)toResolve;
                componentType = ((Class)original).getComponentType();
                toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : BeanUtils.arrayOf(newComponentType);
            } else if (toResolve instanceof GenericArrayType) {
                Type newComponentType;
                original = (GenericArrayType)toResolve;
                componentType = original.getGenericComponentType();
                toResolve = BeanUtils.equal(componentType, newComponentType = BeanUtils.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : BeanUtils.arrayOf(newComponentType);
            } else if (toResolve instanceof ParameterizedType) {
                original = (ParameterizedType)toResolve;
                Type ownerType = original.getOwnerType();
                Type newOwnerType = BeanUtils.resolve(context, contextRawType, ownerType, visitedTypeVariables);
                boolean changed = !BeanUtils.equal(newOwnerType, ownerType);
                Type[] args = original.getActualTypeArguments();
                int length = args.length;
                for (int t = 0; t < length; ++t) {
                    Type resolvedTypeArgument = BeanUtils.resolve(context, contextRawType, args[t], visitedTypeVariables);
                    if (BeanUtils.equal(resolvedTypeArgument, args[t])) continue;
                    if (!changed) {
                        args = (Type[])args.clone();
                        changed = true;
                    }
                    args[t] = resolvedTypeArgument;
                }
                toResolve = changed ? BeanUtils.newParameterizedTypeWithOwner(newOwnerType, original.getRawType(), args) : original;
            } else if (toResolve instanceof WildcardType) {
                Type upperBound;
                original = (WildcardType)toResolve;
                Type[] originalLowerBound = original.getLowerBounds();
                Type[] originalUpperBound = original.getUpperBounds();
                if (originalLowerBound.length == 1) {
                    Type lowerBound = BeanUtils.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                    if (lowerBound != originalLowerBound[0]) {
                        toResolve = BeanUtils.supertypeOf(lowerBound);
                    }
                } else if (originalUpperBound.length == 1 && (upperBound = BeanUtils.resolve(context, contextRawType, originalUpperBound[0], visitedTypeVariables)) != originalUpperBound[0]) {
                    toResolve = BeanUtils.subtypeOf(upperBound);
                }
            }
        }
        if (resolving != null) {
            visitedTypeVariables.put(resolving, toResolve);
        }
        return toResolve;
    }

    static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = BeanUtils.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = BeanUtils.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = BeanUtils.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    static void checkNotPrimitive(Type type) {
        BeanUtils.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                boolean isStaticOrTopLevelClass = Modifier.isStatic(rawTypeAsClass.getModifiers()) || rawTypeAsClass.getEnclosingClass() == null;
                BeanUtils.checkArgument(ownerType != null || isStaticOrTopLevelClass);
            }
            this.ownerType = ownerType == null ? null : BeanUtils.canonicalize(ownerType);
            this.rawType = BeanUtils.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            int length = this.typeArguments.length;
            for (int t = 0; t < length; ++t) {
                BeanUtils.checkNotNull(this.typeArguments[t]);
                BeanUtils.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = BeanUtils.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && BeanUtils.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ BeanUtils.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int length = this.typeArguments.length;
            if (length == 0) {
                return BeanUtils.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
            stringBuilder.append(BeanUtils.typeToString(this.rawType)).append("<").append(BeanUtils.typeToString(this.typeArguments[0]));
            for (int i = 1; i < length; ++i) {
                stringBuilder.append(", ").append(BeanUtils.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = BeanUtils.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && BeanUtils.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return BeanUtils.typeToString(this.componentType) + "[]";
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            BeanUtils.checkArgument(lowerBounds.length <= 1);
            BeanUtils.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                BeanUtils.checkNotNull(lowerBounds[0]);
                BeanUtils.checkNotPrimitive(lowerBounds[0]);
                BeanUtils.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = BeanUtils.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                BeanUtils.checkNotNull(upperBounds[0]);
                BeanUtils.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = BeanUtils.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && BeanUtils.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + BeanUtils.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + BeanUtils.typeToString(this.upperBound);
        }
    }
}

