/*
 * Decompiled with CFR 0.152.
 */
package com.platon.contracts.ppos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.platon.contracts.ppos.abi.Function;
import com.platon.contracts.ppos.dto.CallResponse;
import com.platon.contracts.ppos.dto.TransactionResponse;
import com.platon.contracts.ppos.exception.EstimateGasException;
import com.platon.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.contracts.ppos.utils.EncoderUtils;
import com.platon.contracts.ppos.utils.EstimateGasUtil;
import com.platon.crypto.Credentials;
import com.platon.exceptions.MessageDecodingException;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.DefaultBlockParameterName;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.Response;
import com.platon.protocol.core.methods.request.Transaction;
import com.platon.protocol.core.methods.response.Log;
import com.platon.protocol.core.methods.response.PlatonCall;
import com.platon.protocol.core.methods.response.PlatonEstimateGas;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.rlp.solidity.RlpDecoder;
import com.platon.rlp.solidity.RlpList;
import com.platon.rlp.solidity.RlpString;
import com.platon.rlp.solidity.RlpType;
import com.platon.tx.ManagedTransaction;
import com.platon.tx.RawTransactionManager;
import com.platon.tx.ReadonlyTransactionManager;
import com.platon.tx.TransactionManager;
import com.platon.tx.exceptions.ContractCallException;
import com.platon.tx.exceptions.PlatonCallException;
import com.platon.tx.exceptions.PlatonCallTimeoutException;
import com.platon.tx.gas.ContractGasProvider;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.JSONUtil;
import com.platon.utils.Numeric;
import com.platon.utils.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContract
extends ManagedTransaction {
    private static final Logger log = LoggerFactory.getLogger(BaseContract.class);
    protected String contractAddress;
    protected TransactionReceipt transactionReceipt;

    protected BaseContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
        this.contractAddress = contractAddress;
    }

    protected BaseContract(String contractAddress, Web3j web3j, Credentials credentials) {
        this(contractAddress, web3j, new RawTransactionManager(web3j, credentials));
    }

    protected BaseContract(String contractAddress, Web3j web3j) {
        this(contractAddress, web3j, new ReadonlyTransactionManager(web3j, contractAddress));
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    protected <T> RemoteCall<CallResponse<T>> executeRemoteCallObjectValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<CallResponse<T>>(() -> this.executeCallObjectValueReturn(function, returnType));
    }

    protected <T> RemoteCall<CallResponse<List<T>>> executeRemoteCallListValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<CallResponse<List<T>>>(() -> this.executeCallListValueReturn(function, returnType));
    }

    private <T> CallResponse<T> executeCallObjectValueReturn(Function function, Class<T> returnType) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function)), DefaultBlockParameterName.LATEST).send();
        if (ethCall.hasError()) {
            String lowMessage;
            Response.Error error = ethCall.getError();
            String message = error.getMessage();
            String string = lowMessage = !Strings.isBlank((String)message) ? message.toLowerCase() : null;
            if (!Strings.isBlank((String)lowMessage) && lowMessage.contains("timeout")) {
                throw new PlatonCallTimeoutException(error.getCode(), error.getMessage(), ethCall);
            }
            throw new PlatonCallException(error.getCode(), error.getMessage(), ethCall);
        }
        String result = Numeric.cleanHexPrefix((String)ethCall.getValue());
        if (result == null || "".equals(result)) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        CallRet callRet = JSONUtil.parseObject(new String(Hex.decode((String)result)), CallRet.class);
        if (callRet == null) {
            throw new ContractCallException("Unable to convert response: " + result);
        }
        CallResponse<BigInteger> callResponse = new CallResponse<BigInteger>();
        if (callRet.isStatusOk()) {
            callResponse.setCode(callRet.getCode());
            if (BigInteger.class.isAssignableFrom(returnType)) {
                callResponse.setData(this.numberDecoder(callRet.getRet()));
            } else {
                callResponse.setData((BigInteger)JSONUtil.parseObject(JSONUtil.toJSONString(callRet.getRet()), returnType));
            }
        } else {
            callResponse.setCode(callRet.getCode());
            callResponse.setErrMsg(callRet.getRet().toString());
        }
        return callResponse;
    }

    private BigInteger numberDecoder(Object number) {
        if (number instanceof String) {
            String numberStr = (String)number;
            return Numeric.decodeQuantity((String)numberStr);
        }
        if (number instanceof Number) {
            Number number2 = (Number)number;
            return BigInteger.valueOf(number2.longValue());
        }
        throw new MessageDecodingException("Can not decode number value = " + number);
    }

    private <T> CallResponse<List<T>> executeCallListValueReturn(Function function, Class<T> returnType) throws IOException {
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function)), DefaultBlockParameterName.LATEST).send();
        if (ethCall.hasError()) {
            String lowMessage;
            Response.Error error = ethCall.getError();
            String message = error.getMessage();
            String string = lowMessage = !Strings.isBlank((String)message) ? message.toLowerCase() : null;
            if (!Strings.isBlank((String)lowMessage) && lowMessage.contains("timeout")) {
                throw new PlatonCallTimeoutException(error.getCode(), error.getMessage(), ethCall);
            }
            throw new PlatonCallException(error.getCode(), error.getMessage(), ethCall);
        }
        String result = Numeric.cleanHexPrefix((String)ethCall.getValue());
        if (result == null || "".equals(result)) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        CallRet callRet = JSONUtil.parseObject(new String(Hex.decode((String)result)), CallRet.class);
        if (callRet == null) {
            throw new ContractCallException("Unable to convert response: " + result);
        }
        CallResponse callResponse = new CallResponse();
        if (callRet.isStatusOk()) {
            callResponse.setCode(callRet.getCode());
            callResponse.setData(JSONUtil.parseArray(JSONUtil.toJSONString(callRet.getRet()), returnType));
        } else {
            callResponse.setCode(callRet.getCode());
            callResponse.setErrMsg(callRet.getRet().toString());
        }
        if (callRet.getCode() == 2) {
            callResponse.setCode(0);
            callResponse.setData(Collections.emptyList());
        }
        return callResponse;
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallTransactionStep1(Function function, GasProvider gasProvider) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executeTransactionStep1(function, BigInteger.ZERO, gasProvider));
    }

    protected RemoteCall<PlatonSendTransaction> executeRemoteCallTransactionStep1(Function function) {
        return new RemoteCall<PlatonSendTransaction>(() -> this.executeTransactionStep1(function, BigInteger.ZERO, this.getDefaultGasProvider(function)));
    }

    private RemoteCall<TransactionResponse> executeRemoteCallTransactionStep2(PlatonSendTransaction ethSendTransaction) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransactionStep2(ethSendTransaction));
    }

    public RemoteCall<TransactionResponse> getTransactionResponse(PlatonSendTransaction ethSendTransaction) {
        return this.executeRemoteCallTransactionStep2(ethSendTransaction);
    }

    protected RemoteCall<TransactionResponse> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransaction(function, BigInteger.ZERO, this.getDefaultGasProvider(function)));
    }

    protected RemoteCall<TransactionResponse> executeRemoteCallTransaction(Function function, GasProvider gasProvider) {
        return new RemoteCall<TransactionResponse>(() -> this.executeTransaction(function, BigInteger.ZERO, gasProvider));
    }

    protected GasProvider getDefaultGasProvider(Function function) throws IOException, EstimateGasException {
        return this.getDefaultGasProviderRemote(function);
    }

    private GasProvider getDefaultGasProviderRemote(Function function) throws IOException, EstimateGasException {
        Transaction transaction = Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, EncoderUtils.functionEncoder(function));
        PlatonEstimateGas platonEstimateGas = this.web3j.platonEstimateGas(transaction).send();
        if (platonEstimateGas.hasError()) {
            if (platonEstimateGas.getError().getCode() == 4) {
                log.error("estimate gas error, code:={}, message:={}", (Object)platonEstimateGas.getError().getCode(), (Object)platonEstimateGas.getError().getData());
                Response.Error error = (Response.Error)JSON.parseObject((String)platonEstimateGas.getError().getData(), Response.Error.class);
                throw new EstimateGasException(error.getMessage());
            }
            throw new EstimateGasException(platonEstimateGas.getError().getMessage());
        }
        BigInteger gasLimit = Numeric.decodeQuantity((String)((String)platonEstimateGas.getResult()));
        BigInteger gasPrice = this.getDefaultGasPrice(function.getType());
        return new ContractGasProvider(gasPrice, gasLimit);
    }

    private GasProvider getDefaultGasProviderLocal(Function function) throws IOException, NoSupportFunctionType {
        BigInteger gasLimit = EstimateGasUtil.getGasLimit(function);
        BigInteger gasPrice = this.getDefaultGasPrice(function.getType());
        ContractGasProvider gasProvider = new ContractGasProvider(gasPrice, gasLimit);
        return gasProvider;
    }

    private BigInteger getDefaultGasPrice(int type) throws IOException {
        if (NetworkParameters.ReservedChainId.Alaya.getChainId() == NetworkParameters.getChainId() || NetworkParameters.ReservedHrp.Alaya.getHrp().equalsIgnoreCase(NetworkParameters.getHrp())) {
            switch (type) {
                case 2000: {
                    return BigInteger.valueOf(150000L).multiply(BigInteger.valueOf(1000000000L));
                }
                case 2001: {
                    return BigInteger.valueOf(210000L).multiply(BigInteger.valueOf(1000000000L));
                }
                case 2002: {
                    return BigInteger.valueOf(200000L).multiply(BigInteger.valueOf(1000000000L));
                }
                case 2005: {
                    return BigInteger.valueOf(300000L).multiply(BigInteger.valueOf(1000000000L));
                }
            }
            return this.web3j.platonGasPrice().send().getGasPrice();
        }
        switch (type) {
            case 2000: {
                return BigInteger.valueOf(1500000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2001: {
                return BigInteger.valueOf(0x200B20L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2002: {
                return BigInteger.valueOf(2000000L).multiply(BigInteger.valueOf(1000000000L));
            }
            case 2005: {
                return BigInteger.valueOf(3000000L).multiply(BigInteger.valueOf(1000000000L));
            }
        }
        return this.web3j.platonGasPrice().send().getGasPrice();
    }

    private TransactionResponse executeTransaction(Function function, BigInteger vonValue, GasProvider gasProvider) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, EncoderUtils.functionEncoder(function), vonValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
        return this.getResponseFromTransactionReceipt(receipt);
    }

    private PlatonSendTransaction executeTransactionStep1(Function function, BigInteger vonValue, GasProvider gasProvider) throws IOException {
        return this.sendPlatonRawTransaction(this.contractAddress, EncoderUtils.functionEncoder(function), vonValue, gasProvider.getGasPrice(), gasProvider.getGasLimit());
    }

    private TransactionResponse executeTransactionStep2(PlatonSendTransaction ethSendTransaction) throws IOException, TransactionException {
        TransactionReceipt receipt = this.getTransactionReceipt(ethSendTransaction);
        return this.getResponseFromTransactionReceipt(receipt);
    }

    private TransactionResponse getResponseFromTransactionReceipt(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt log data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        TransactionResponse transactionResponse = new TransactionResponse();
        transactionResponse.setCode(statusCode);
        transactionResponse.setTransactionReceipt(transactionReceipt);
        return transactionResponse;
    }

    protected List<RlpType> decodePPOSLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        return rlpList;
    }

    public static class CallRet {
        @JSONField(name="Code")
        private int code;
        @JSONField(name="Ret")
        private Object ret;

        public boolean isStatusOk() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public Object getRet() {
            return this.ret;
        }

        public void setRet(Object ret) {
            this.ret = ret;
        }

        public String toString() {
            return "CallRet [code=" + this.code + ", ret=" + this.ret + "]";
        }
    }
}

