/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.admin;

import com.platon.protocol.Web3jService;
import com.platon.protocol.admin.Admin;
import com.platon.protocol.admin.methods.response.BooleanResponse;
import com.platon.protocol.admin.methods.response.NewAccountIdentifier;
import com.platon.protocol.admin.methods.response.PersonalEcRecover;
import com.platon.protocol.admin.methods.response.PersonalImportRawKey;
import com.platon.protocol.admin.methods.response.PersonalListAccounts;
import com.platon.protocol.admin.methods.response.PersonalListWallets;
import com.platon.protocol.admin.methods.response.PersonalSign;
import com.platon.protocol.admin.methods.response.PersonalUnlockAccount;
import com.platon.protocol.admin.methods.response.TxPoolContent;
import com.platon.protocol.core.JsonRpc2_0Web3j;
import com.platon.protocol.core.Request;
import com.platon.protocol.core.methods.request.Transaction;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.PlatonSignTransaction;
import com.platon.protocol.core.methods.response.VoidResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;

public class JsonRpc2_0Admin
extends JsonRpc2_0Web3j
implements Admin {
    public JsonRpc2_0Admin(Web3jService web3jService) {
        super(web3jService);
    }

    public JsonRpc2_0Admin(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        super(web3jService, pollingInterval, scheduledExecutorService);
    }

    @Override
    public Request<?, PersonalImportRawKey> personalImportRawKey(String keydata, String password) {
        return new Request<String, PersonalImportRawKey>("personal_importRawKey", Arrays.asList(keydata, password), this.web3jService, PersonalImportRawKey.class);
    }

    @Override
    public Request<?, BooleanResponse> personalLockAccount(String accountId) {
        return new Request<String, BooleanResponse>("personal_lockAccount", Arrays.asList(accountId), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, PersonalSign> personalSign(String message, String accountId, String password) {
        return new Request<String, PersonalSign>("personal_sign", Arrays.asList(message, accountId, password), this.web3jService, PersonalSign.class);
    }

    @Override
    public Request<?, PersonalSign> personalSignAndSendTransaction(Transaction transaction, String password) {
        return new Request<Object, PersonalSign>("personal_signAndSendTransaction", Arrays.asList(transaction, password), this.web3jService, PersonalSign.class);
    }

    @Override
    public Request<?, PlatonSignTransaction> personalSignTransaction(Transaction transaction, String password) {
        return new Request<Object, PlatonSignTransaction>("personal_signTransaction", Arrays.asList(transaction, password), this.web3jService, PlatonSignTransaction.class);
    }

    @Override
    public Request<?, PersonalEcRecover> personalEcRecover(String hexMessage, String signedMessage) {
        return new Request<String, PersonalEcRecover>("personal_ecRecover", Arrays.asList(hexMessage, signedMessage), this.web3jService, PersonalEcRecover.class);
    }

    @Override
    public Request<?, PersonalListWallets> personalListWallets() {
        return new Request("personal_listWallets", Collections.emptyList(), this.web3jService, PersonalListWallets.class);
    }

    @Override
    public Request<?, PersonalListAccounts> personalListAccounts() {
        return new Request("personal_listAccounts", Collections.emptyList(), this.web3jService, PersonalListAccounts.class);
    }

    @Override
    public Request<?, NewAccountIdentifier> personalNewAccount(String password) {
        return new Request<String, NewAccountIdentifier>("personal_newAccount", Arrays.asList(password), this.web3jService, NewAccountIdentifier.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password, BigInteger duration) {
        ArrayList<Object> attributes = new ArrayList<Object>(3);
        attributes.add(accountId);
        attributes.add(password);
        if (duration != null) {
            attributes.add(duration.longValue());
        } else {
            attributes.add(null);
        }
        return new Request("personal_unlockAccount", attributes, this.web3jService, PersonalUnlockAccount.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password) {
        return this.personalUnlockAccount(accountId, password, null);
    }

    @Override
    public Request<?, VoidResponse> personalOpenWallet(String url, String passphrase) {
        return new Request<String, VoidResponse>("personal_openWallet", Arrays.asList(url, passphrase), this.web3jService, VoidResponse.class);
    }

    @Override
    public Request<?, PlatonSendTransaction> personalSendTransaction(Transaction transaction, String passphrase) {
        return new Request<Object, PlatonSendTransaction>("personal_sendTransaction", Arrays.asList(transaction, passphrase), this.web3jService, PlatonSendTransaction.class);
    }

    @Override
    public Request<?, TxPoolContent> txPoolContent() {
        return new Request("txpool_content", Collections.emptyList(), this.web3jService, TxPoolContent.class);
    }
}

