/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.platon.protocol.ObjectMapperFactory;
import com.platon.protocol.core.Response;
import java.io.IOException;
import java.util.Map;

public class AdminNodeInfo
extends Response<NodeInfo> {
    @Override
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(NodeInfo result) {
        super.setResult(result);
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<NodeInfo> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public NodeInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (NodeInfo)this.objectReader.readValue(jsonParser, NodeInfo.class);
            }
            return null;
        }
    }

    public static class NodeInfo {
        private String enode;
        private String id;
        private String ip;
        private String listenAddr;
        private String name;
        private String consensus;

        @JsonProperty(value="protocols")
        private void consensusDeserializer(Map<String, Object> protocols) {
            if (protocols.containsKey("istanbul")) {
                this.consensus = "istanbul";
            } else if (protocols.containsKey("clique")) {
                this.consensus = "clique";
            } else if (protocols.containsKey("eth")) {
                Map eth = (Map)protocols.get("eth");
                this.consensus = (String)eth.get("consensus");
            } else {
                this.consensus = "unknown";
            }
        }

        public NodeInfo() {
        }

        public NodeInfo(String enode, String id, String ip, String listenAddr, String name, String consensus) {
            this.enode = enode;
            this.id = id;
            this.ip = ip;
            this.listenAddr = listenAddr;
            this.name = name;
            this.consensus = consensus;
        }

        public String getEnode() {
            return this.enode;
        }

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getListenAddr() {
            return this.listenAddr;
        }

        public String getName() {
            return this.name;
        }

        public String getConsensus() {
            return this.consensus;
        }
    }
}

