/*
 * Decompiled with CFR 0.152.
 */
package com.platon.tx;

import com.platon.crypto.Credentials;
import com.platon.protocol.Web3j;
import com.platon.tx.RawTransactionManager;
import com.platon.tx.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.math.BigInteger;

public class FastRawTransactionManager
extends RawTransactionManager {
    private volatile BigInteger nonce = BigInteger.valueOf(-1L);

    public FastRawTransactionManager(Web3j web3j, Credentials credentials) {
        super(web3j, credentials);
    }

    public FastRawTransactionManager(Web3j web3j, Credentials credentials, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(web3j, credentials, transactionReceiptProcessor);
    }

    @Override
    protected synchronized BigInteger getNonce() throws IOException {
        this.nonce = this.nonce.signum() == -1 ? super.getNonce() : this.nonce.add(BigInteger.ONE);
        return this.nonce;
    }

    public BigInteger getCurrentNonce() {
        return this.nonce;
    }

    public synchronized void resetNonce() throws IOException {
        this.nonce = super.getNonce();
    }

    public synchronized void setNonce(BigInteger value) {
        this.nonce = value;
    }
}

