/*
 * Decompiled with CFR 0.152.
 */
package com.platon.tx;

import com.platon.crypto.Credentials;
import com.platon.crypto.Hash;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.TransactionEncoder;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.DefaultBlockParameterName;
import com.platon.protocol.core.methods.response.PlatonGetTransactionCount;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.tx.TransactionManager;
import com.platon.tx.exceptions.TxHashMismatchException;
import com.platon.tx.response.TransactionReceiptProcessor;
import com.platon.utils.Numeric;
import com.platon.utils.TxHashVerifier;
import java.io.IOException;
import java.math.BigInteger;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
    }

    protected BigInteger getNonce() throws IOException {
        PlatonGetTransactionCount ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.PENDING).send();
        if (ethGetTransactionCount.getTransactionCount().intValue() == 0) {
            ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.LATEST).send();
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public PlatonSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public PlatonSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        byte[] signedMessage = NetworkParameters.getChainId() > -1L ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)NetworkParameters.getChainId(), (Credentials)this.credentials) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        PlatonSendTransaction ethSendTransaction = this.web3j.platonSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }
}

