/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.util.List;

public class Fastjson1xWriterModule
implements ObjectWriterModule {
    final ObjectWriterProvider provider;

    public Fastjson1xWriterModule(ObjectWriterProvider provider) {
        this.provider = provider;
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        if (objectClass != null && JSONAware.class.isAssignableFrom(objectClass)) {
            return JSONAwareWriter.INSTANCE;
        }
        return null;
    }

    static class JSONAwareWriter
    implements ObjectWriter {
        static final JSONAwareWriter INSTANCE = new JSONAwareWriter();

        JSONAwareWriter() {
        }

        public List<FieldWriter> getFieldWriters() {
            return null;
        }

        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            throw new UnsupportedOperationException();
        }

        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            JSONAware jsonAware = (JSONAware)object;
            String str = jsonAware.toJSONString();
            jsonWriter.writeRaw(str);
        }
    }
}

