/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.ToFloatFunction;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Method;

final class FieldWriterFloatValueFunc
extends FieldWriterImpl {
    final Method method;
    final ToFloatFunction function;

    protected FieldWriterFloatValueFunc(String fieldName, int ordinal, Method method, ToFloatFunction function) {
        super(fieldName, ordinal, 0L, null, Float.TYPE, Float.TYPE);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getFieldValue(Object object) {
        return Float.valueOf(this.function.applyAsFloat(object));
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        float fieldValue = this.function.applyAsFloat(object);
        jsonWriter.writeFloat(fieldValue);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, Object object) {
        float value;
        try {
            value = this.function.applyAsFloat(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeFloat(value);
        return true;
    }
}

