/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm.datatypes;

import com.platon.rlp.wasm.datatypes.Int;
import java.math.BigInteger;

public class Int32
extends Int {
    public int value;
    public static final int size = 64;

    private Int32(int value) {
        this.value = value;
        this.unsingedValue = new BigInteger(Long.toUnsignedString(Int32.encodeZigZag64(value)));
    }

    private Int32(BigInteger unsingedValue) {
        this.unsingedValue = unsingedValue;
        this.value = (int)Int32.decodeZigZag64(unsingedValue.longValue());
    }

    public static Int32 of(long value) {
        if (BigInteger.valueOf(value).bitLength() >= 32) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 32");
        }
        return new Int32((int)value);
    }

    public static Int32 ofUnsignedValue(BigInteger unsingedValue) {
        return new Int32(unsingedValue);
    }

    public static Int32 of(BigInteger value) {
        if (value.bitLength() >= 32) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 32");
        }
        return new Int32(Int32.encodeZigZag(value, 64));
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int32 that = (Int32)o;
        return this.value == that.value;
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }
}

