/*
 * Decompiled with CFR 0.152.
 */
package com.platon.contracts.ppos;

import com.platon.abi.solidity.datatypes.BytesType;
import com.platon.abi.solidity.datatypes.generated.Uint16;
import com.platon.abi.solidity.datatypes.generated.Uint256;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import com.platon.bech32.Bech32;
import com.platon.contracts.ppos.BaseContract;
import com.platon.contracts.ppos.abi.Function;
import com.platon.contracts.ppos.dto.CallResponse;
import com.platon.contracts.ppos.dto.TransactionResponse;
import com.platon.contracts.ppos.dto.enums.DelegateAmountType;
import com.platon.contracts.ppos.dto.enums.StakingAmountType;
import com.platon.contracts.ppos.dto.resp.Delegation;
import com.platon.contracts.ppos.dto.resp.DelegationIdInfo;
import com.platon.contracts.ppos.dto.resp.DelegationLockInfo;
import com.platon.contracts.ppos.dto.resp.RedeemDelegation;
import com.platon.contracts.ppos.dto.resp.UnDelegation;
import com.platon.contracts.ppos.exception.EstimateGasException;
import com.platon.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.crypto.Credentials;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.rlp.solidity.RlpDecoder;
import com.platon.rlp.solidity.RlpString;
import com.platon.rlp.solidity.RlpType;
import com.platon.tx.TransactionManager;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class DelegateContract
extends BaseContract {
    public static DelegateContract load(Web3j web3j) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j);
    }

    public static DelegateContract load(Web3j web3j, TransactionManager transactionManager) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j, transactionManager);
    }

    public static DelegateContract load(Web3j web3j, Credentials credentials) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private DelegateContract(String contractAddress, Web3j web3j, Credentials credentials) {
        super(contractAddress, web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    @Deprecated
    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, delegateAmountType, amount);
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, delegateAmountType, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    @Deprecated
    public GasProvider getDelegateGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.getDefaultGasProvider(function);
    }

    public GasProvider getDelegateGasProvider(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createDelegateFunction(nodeId, delegateAmountType, amount);
        return this.getDefaultGasProvider(function);
    }

    @Deprecated
    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, delegateAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, delegateAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createDelegateFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        return this.createDelegateFunction(nodeId, stakingAmountType.getValue(), amount);
    }

    private Function createDelegateFunction(String nodeId, DelegateAmountType delegateAmountType, BigInteger amount) {
        return this.createDelegateFunction(nodeId, delegateAmountType.getValue(), amount);
    }

    private Function createDelegateFunction(String nodeId, int delegateAmountType, BigInteger amount) {
        Function function = new Function(1004, Arrays.asList(new Uint16((long)delegateAmountType), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getUnDelegateGasProvider(String nodeId, BigInteger stakingBlockNum, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createUnDelegateFunction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = new Function(1005, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    @Deprecated
    public BigInteger decodeUnDelegateLog(TransactionReceipt transactionReceipt) throws TransactionException {
        return this.decodeUnDelegateLogOfNew(transactionReceipt).getDelegateIncome();
    }

    public UnDelegation decodeUnDelegateLogOfNew(TransactionReceipt transactionReceipt) throws TransactionException {
        List<RlpType> rlpList = this.decodePPOSLog(transactionReceipt);
        UnDelegation result = new UnDelegation();
        BigInteger delegateIncome = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).asPositiveBigInteger();
        result.setDelegateIncome(delegateIncome);
        if (rlpList.size() > 2) {
            BigInteger released = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(2)).getBytes()).getValues().get(0)).asPositiveBigInteger();
            BigInteger restrictingPlan = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(3)).getBytes()).getValues().get(0)).asPositiveBigInteger();
            BigInteger lockReleased = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(4)).getBytes()).getValues().get(0)).asPositiveBigInteger();
            BigInteger lockRestrictingPlan = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(5)).getBytes()).getValues().get(0)).asPositiveBigInteger();
            result.setReleased(Optional.of(released));
            result.setRestrictingPlan(Optional.of(restrictingPlan));
            result.setLockReleased(Optional.of(lockReleased));
            result.setLockRestrictingPlan(Optional.of(lockRestrictingPlan));
        }
        return result;
    }

    public RemoteCall<TransactionResponse> redeemDelegation() {
        Function function = this.createRedeemDelegationFunction();
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> redeemDelegation(GasProvider gasProvider) {
        Function function = this.createRedeemDelegationFunction();
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getRedeemDelegationGasProvider() throws IOException, EstimateGasException {
        Function function = this.createRedeemDelegationFunction();
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> redeemDelegationReturnTransaction() {
        Function function = this.createRedeemDelegationFunction();
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> redeemDelegationReturnTransaction(GasProvider gasProvider) {
        Function function = this.createRedeemDelegationFunction();
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createRedeemDelegationFunction() {
        Function function = new Function(1006);
        return function;
    }

    public RedeemDelegation decodeRedeemDelegateLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<RlpType> rlpList = this.decodePPOSLog(transactionReceipt);
        RedeemDelegation result = new RedeemDelegation();
        BigInteger released = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).asPositiveBigInteger();
        BigInteger restrictingPlan = ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(2)).getBytes()).getValues().get(0)).asPositiveBigInteger();
        result.setReleased(released);
        result.setRestrictingPlan(restrictingPlan);
        return result;
    }

    public RemoteCall<CallResponse<Delegation>> getDelegateInfo(String nodeId, String delAddr, BigInteger stakingBlockNum) {
        Function function = new Function(1104, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Bech32.addressDecode((String)delAddr)), new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return this.executeRemoteCallObjectValueReturn(function, Delegation.class);
    }

    public RemoteCall<CallResponse<List<DelegationIdInfo>>> getRelatedListByDelAddr(String address) {
        Function function = new Function(1103, Arrays.asList(new BytesType(Bech32.addressDecode((String)address))));
        return this.executeRemoteCallListValueReturn(function, DelegationIdInfo.class);
    }

    public RemoteCall<CallResponse<DelegationLockInfo>> getDelegationLockInfo(String delAddr) {
        Function function = new Function(1106, Arrays.asList(new BytesType(Bech32.addressDecode((String)delAddr))));
        return this.executeRemoteCallObjectValueReturn(function, DelegationLockInfo.class);
    }
}

