/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.core;

import com.platon.protocol.Web3j;
import com.platon.protocol.Web3jService;
import com.platon.protocol.admin.methods.response.BooleanResponse;
import com.platon.protocol.admin.methods.response.TxPoolStatus;
import com.platon.protocol.admin.methods.response.admin.AdminDataDir;
import com.platon.protocol.core.DefaultBlockParameter;
import com.platon.protocol.core.Request;
import com.platon.protocol.core.methods.request.PlatonFilter;
import com.platon.protocol.core.methods.request.ShhFilter;
import com.platon.protocol.core.methods.request.ShhPost;
import com.platon.protocol.core.methods.response.AdminNodeInfo;
import com.platon.protocol.core.methods.response.AdminPeerEvents;
import com.platon.protocol.core.methods.response.AdminPeers;
import com.platon.protocol.core.methods.response.AdminProgramVersion;
import com.platon.protocol.core.methods.response.AdminSchnorrNIZKProve;
import com.platon.protocol.core.methods.response.DbGetHex;
import com.platon.protocol.core.methods.response.DbGetString;
import com.platon.protocol.core.methods.response.DbPutHex;
import com.platon.protocol.core.methods.response.DbPutString;
import com.platon.protocol.core.methods.response.DebugEconomicConfig;
import com.platon.protocol.core.methods.response.DebugWaitSlashingNodeList;
import com.platon.protocol.core.methods.response.Log;
import com.platon.protocol.core.methods.response.NetListening;
import com.platon.protocol.core.methods.response.NetPeerCount;
import com.platon.protocol.core.methods.response.NetVersion;
import com.platon.protocol.core.methods.response.PlatonAccounts;
import com.platon.protocol.core.methods.response.PlatonBlock;
import com.platon.protocol.core.methods.response.PlatonBlockNumber;
import com.platon.protocol.core.methods.response.PlatonCall;
import com.platon.protocol.core.methods.response.PlatonChainId;
import com.platon.protocol.core.methods.response.PlatonEstimateGas;
import com.platon.protocol.core.methods.response.PlatonEvidences;
import com.platon.protocol.core.methods.response.PlatonGasPrice;
import com.platon.protocol.core.methods.response.PlatonGetAddressHrp;
import com.platon.protocol.core.methods.response.PlatonGetBalance;
import com.platon.protocol.core.methods.response.PlatonGetBlockTransactionCountByHash;
import com.platon.protocol.core.methods.response.PlatonGetBlockTransactionCountByNumber;
import com.platon.protocol.core.methods.response.PlatonGetCode;
import com.platon.protocol.core.methods.response.PlatonGetStorageAt;
import com.platon.protocol.core.methods.response.PlatonGetTransactionCount;
import com.platon.protocol.core.methods.response.PlatonGetTransactionReceipt;
import com.platon.protocol.core.methods.response.PlatonLog;
import com.platon.protocol.core.methods.response.PlatonPendingTransactions;
import com.platon.protocol.core.methods.response.PlatonProtocolVersion;
import com.platon.protocol.core.methods.response.PlatonRawTransaction;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.PlatonSign;
import com.platon.protocol.core.methods.response.PlatonSignTransaction;
import com.platon.protocol.core.methods.response.PlatonSubscribe;
import com.platon.protocol.core.methods.response.PlatonSyncing;
import com.platon.protocol.core.methods.response.PlatonTransaction;
import com.platon.protocol.core.methods.response.PlatonUninstallFilter;
import com.platon.protocol.core.methods.response.ShhAddToGroup;
import com.platon.protocol.core.methods.response.ShhHasIdentity;
import com.platon.protocol.core.methods.response.ShhMessages;
import com.platon.protocol.core.methods.response.ShhNewFilter;
import com.platon.protocol.core.methods.response.ShhNewGroup;
import com.platon.protocol.core.methods.response.ShhNewIdentity;
import com.platon.protocol.core.methods.response.ShhUninstallFilter;
import com.platon.protocol.core.methods.response.ShhVersion;
import com.platon.protocol.core.methods.response.Transaction;
import com.platon.protocol.core.methods.response.Web3ClientVersion;
import com.platon.protocol.core.methods.response.Web3Sha3;
import com.platon.protocol.rx.JsonRpc2_0Rx;
import com.platon.protocol.websocket.events.LogNotification;
import com.platon.protocol.websocket.events.NewHeadsNotification;
import com.platon.utils.Async;
import com.platon.utils.Numeric;
import com.platon.utils.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import rx.Observable;

public class JsonRpc2_0Web3j
implements Web3j {
    public static final int DEFAULT_BLOCK_TIME = 2000;
    protected final Web3jService web3jService;
    private final JsonRpc2_0Rx web3jRx;
    private final long blockTime;
    private final ScheduledExecutorService scheduledExecutorService;

    public JsonRpc2_0Web3j(Web3jService web3jService) {
        this(web3jService, 2000L, Async.defaultExecutorService());
    }

    public JsonRpc2_0Web3j(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        this.web3jService = web3jService;
        this.web3jRx = new JsonRpc2_0Rx(this, scheduledExecutorService);
        this.blockTime = pollingInterval;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public Request<?, Web3ClientVersion> web3ClientVersion() {
        return new Request("web3_clientVersion", Collections.emptyList(), this.web3jService, Web3ClientVersion.class);
    }

    @Override
    public Request<?, Web3Sha3> web3Sha3(String data) {
        return new Request<String, Web3Sha3>("web3_sha3", Arrays.asList(data), this.web3jService, Web3Sha3.class);
    }

    @Override
    public Request<?, NetVersion> netVersion() {
        return new Request("net_version", Collections.emptyList(), this.web3jService, NetVersion.class);
    }

    @Override
    public Request<?, NetListening> netListening() {
        return new Request("net_listening", Collections.emptyList(), this.web3jService, NetListening.class);
    }

    @Override
    public Request<?, NetPeerCount> netPeerCount() {
        return new Request("net_peerCount", Collections.emptyList(), this.web3jService, NetPeerCount.class);
    }

    @Override
    public Request<?, AdminNodeInfo> adminNodeInfo() {
        return new Request("admin_nodeInfo", Collections.emptyList(), this.web3jService, AdminNodeInfo.class);
    }

    @Override
    public Request<?, AdminPeers> adminPeers() {
        return new Request("admin_peers", Collections.emptyList(), this.web3jService, AdminPeers.class);
    }

    @Override
    public Request<?, BooleanResponse> adminAddPeer(String url) {
        return new Request<String, BooleanResponse>("admin_addPeer", Arrays.asList(url), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminRemovePeer(String url) {
        return new Request<String, BooleanResponse>("admin_removePeer", Arrays.asList(url), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, AdminDataDir> adminDataDir() {
        return new Request("admin_datadir", Collections.emptyList(), this.web3jService, AdminDataDir.class);
    }

    @Override
    public Request<?, BooleanResponse> adminStartRPC(String host, int port, String cors, String apis) {
        if (host == null) {
            host = "localhost";
        }
        if (cors == null) {
            cors = "";
        }
        if (Strings.isBlank((String)apis)) {
            apis = "hskchain,net,web3,debug,admin";
        }
        return new Request<Serializable, BooleanResponse>("admin_startRPC", Arrays.asList(host, port, cors, apis), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminStartWS(String host, int port, String cors, String apis) {
        if (host == null) {
            host = "localhost";
        }
        if (cors == null) {
            cors = "";
        }
        if (Strings.isBlank((String)apis)) {
            apis = "hskchain,net,web3,debug,admin";
        }
        return new Request<Serializable, BooleanResponse>("admin_startWS", Arrays.asList(host, port, cors, apis), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminStopRPC() {
        return new Request("admin_stopRPC", Collections.emptyList(), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminStopWS() {
        return new Request("admin_stopWS", Collections.emptyList(), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminExportChain(String file) {
        return new Request<String, BooleanResponse>("admin_exportChain", Arrays.asList(file), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> adminImportChain(String file) {
        return new Request<String, BooleanResponse>("admin_importChain", Arrays.asList(file), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, PlatonProtocolVersion> platonProtocolVersion() {
        return new Request("hskchain_protocolVersion", Collections.emptyList(), this.web3jService, PlatonProtocolVersion.class);
    }

    @Override
    public Request<?, PlatonSyncing> platonSyncing() {
        return new Request("hskchain_syncing", Collections.emptyList(), this.web3jService, PlatonSyncing.class);
    }

    @Override
    public Request<?, PlatonGasPrice> platonGasPrice() {
        return new Request("hskchain_gasPrice", Collections.emptyList(), this.web3jService, PlatonGasPrice.class);
    }

    @Override
    public Request<?, PlatonAccounts> platonAccounts() {
        return new Request("hskchain_accounts", Collections.emptyList(), this.web3jService, PlatonAccounts.class);
    }

    @Override
    public Request<?, PlatonBlockNumber> platonBlockNumber() {
        return new Request("hskchain_blockNumber", Collections.emptyList(), this.web3jService, PlatonBlockNumber.class);
    }

    @Override
    public Request<?, PlatonGetBalance> platonGetBalance(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, PlatonGetBalance>("hskchain_getBalance", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, PlatonGetBalance.class);
    }

    @Override
    public Request<?, PlatonGetStorageAt> platonGetStorageAt(String address, BigInteger position, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, PlatonGetStorageAt>("hskchain_getStorageAt", Arrays.asList(address, Numeric.encodeQuantity((BigInteger)position), defaultBlockParameter.getValue()), this.web3jService, PlatonGetStorageAt.class);
    }

    @Override
    public Request<?, PlatonGetTransactionCount> platonGetTransactionCount(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, PlatonGetTransactionCount>("hskchain_getTransactionCount", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, PlatonGetTransactionCount.class);
    }

    @Override
    public Request<?, PlatonGetBlockTransactionCountByHash> platonGetBlockTransactionCountByHash(String blockHash) {
        return new Request<String, PlatonGetBlockTransactionCountByHash>("hskchain_getBlockTransactionCountByHash", Arrays.asList(blockHash), this.web3jService, PlatonGetBlockTransactionCountByHash.class);
    }

    @Override
    public Request<?, PlatonGetBlockTransactionCountByNumber> platonGetBlockTransactionCountByNumber(DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, PlatonGetBlockTransactionCountByNumber>("hskchain_getBlockTransactionCountByNumber", Arrays.asList(defaultBlockParameter.getValue()), this.web3jService, PlatonGetBlockTransactionCountByNumber.class);
    }

    @Override
    public Request<?, PlatonGetCode> platonGetCode(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, PlatonGetCode>("hskchain_getCode", Arrays.asList(address, defaultBlockParameter.getValue()), this.web3jService, PlatonGetCode.class);
    }

    @Override
    public Request<?, PlatonSign> platonSign(String address, String sha3HashOfDataToSign) {
        return new Request<String, PlatonSign>("hskchain_sign", Arrays.asList(address, sha3HashOfDataToSign), this.web3jService, PlatonSign.class);
    }

    @Override
    public Request<?, PlatonSendTransaction> platonSendTransaction(com.platon.protocol.core.methods.request.Transaction transaction) {
        return new Request<com.platon.protocol.core.methods.request.Transaction, PlatonSendTransaction>("hskchain_sendTransaction", Arrays.asList(transaction), this.web3jService, PlatonSendTransaction.class);
    }

    @Override
    public Request<?, PlatonSendTransaction> platonSendRawTransaction(String signedTransactionData) {
        return new Request<String, PlatonSendTransaction>("hskchain_sendRawTransaction", Arrays.asList(signedTransactionData), this.web3jService, PlatonSendTransaction.class);
    }

    @Override
    public Request<?, PlatonCall> platonCall(com.platon.protocol.core.methods.request.Transaction transaction, DefaultBlockParameter defaultBlockParameter) {
        return new Request<Object, PlatonCall>("hskchain_call", Arrays.asList(transaction, defaultBlockParameter), this.web3jService, PlatonCall.class);
    }

    @Override
    public Request<?, PlatonEstimateGas> platonEstimateGas(com.platon.protocol.core.methods.request.Transaction transaction) {
        return new Request<com.platon.protocol.core.methods.request.Transaction, PlatonEstimateGas>("hskchain_estimateGas", Arrays.asList(transaction), this.web3jService, PlatonEstimateGas.class);
    }

    @Override
    public Request<?, PlatonBlock> platonGetBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return new Request<Serializable, PlatonBlock>("hskchain_getBlockByHash", Arrays.asList(blockHash, returnFullTransactionObjects), this.web3jService, PlatonBlock.class);
    }

    @Override
    public Request<?, PlatonBlock> platonGetBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean returnFullTransactionObjects) {
        return new Request<Serializable, PlatonBlock>("hskchain_getBlockByNumber", Arrays.asList(defaultBlockParameter.getValue(), returnFullTransactionObjects), this.web3jService, PlatonBlock.class);
    }

    @Override
    public Request<?, PlatonTransaction> platonGetTransactionByHash(String transactionHash) {
        return new Request<String, PlatonTransaction>("hskchain_getTransactionByHash", Arrays.asList(transactionHash), this.web3jService, PlatonTransaction.class);
    }

    @Override
    public Request<?, PlatonPendingTransactions> platonPendingTx() {
        return new Request("hskchain_pendingTransactions", Collections.emptyList(), this.web3jService, PlatonPendingTransactions.class);
    }

    @Override
    public Request<?, PlatonTransaction> platonGetTransactionByBlockHashAndIndex(String blockHash, BigInteger transactionIndex) {
        return new Request<String, PlatonTransaction>("hskchain_getTransactionByBlockHashAndIndex", Arrays.asList(blockHash, Numeric.encodeQuantity((BigInteger)transactionIndex)), this.web3jService, PlatonTransaction.class);
    }

    @Override
    public Request<?, PlatonTransaction> platonGetTransactionByBlockNumberAndIndex(DefaultBlockParameter defaultBlockParameter, BigInteger transactionIndex) {
        return new Request<String, PlatonTransaction>("hskchain_getTransactionByBlockNumberAndIndex", Arrays.asList(defaultBlockParameter.getValue(), Numeric.encodeQuantity((BigInteger)transactionIndex)), this.web3jService, PlatonTransaction.class);
    }

    @Override
    public Request<?, PlatonGetTransactionReceipt> platonGetTransactionReceipt(String transactionHash) {
        return new Request<String, PlatonGetTransactionReceipt>("hskchain_getTransactionReceipt", Arrays.asList(transactionHash), this.web3jService, PlatonGetTransactionReceipt.class);
    }

    @Override
    public Request<?, com.platon.protocol.core.methods.response.PlatonFilter> platonNewFilter(PlatonFilter platonFilter) {
        return new Request<PlatonFilter, com.platon.protocol.core.methods.response.PlatonFilter>("hskchain_newFilter", Arrays.asList(platonFilter), this.web3jService, com.platon.protocol.core.methods.response.PlatonFilter.class);
    }

    @Override
    public Request<?, com.platon.protocol.core.methods.response.PlatonFilter> platonNewBlockFilter() {
        return new Request("hskchain_newBlockFilter", Collections.emptyList(), this.web3jService, com.platon.protocol.core.methods.response.PlatonFilter.class);
    }

    @Override
    public Request<?, com.platon.protocol.core.methods.response.PlatonFilter> platonNewPendingTransactionFilter() {
        return new Request("hskchain_newPendingTransactionFilter", Collections.emptyList(), this.web3jService, com.platon.protocol.core.methods.response.PlatonFilter.class);
    }

    @Override
    public Request<?, PlatonUninstallFilter> platonUninstallFilter(BigInteger filterId) {
        return new Request<String, PlatonUninstallFilter>("hskchain_uninstallFilter", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, PlatonUninstallFilter.class);
    }

    @Override
    public Request<?, PlatonLog> platonGetFilterChanges(BigInteger filterId) {
        return new Request<String, PlatonLog>("hskchain_getFilterChanges", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, PlatonLog.class);
    }

    @Override
    public Request<?, PlatonLog> platonGetFilterLogs(BigInteger filterId) {
        return new Request<String, PlatonLog>("hskchain_getFilterLogs", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, PlatonLog.class);
    }

    @Override
    public Request<?, PlatonLog> platonGetLogs(PlatonFilter platonFilter) {
        return new Request<PlatonFilter, PlatonLog>("hskchain_getLogs", Arrays.asList(platonFilter), this.web3jService, PlatonLog.class);
    }

    @Override
    public Request<?, DbPutString> dbPutString(String databaseName, String keyName, String stringToStore) {
        return new Request<String, DbPutString>("db_putString", Arrays.asList(databaseName, keyName, stringToStore), this.web3jService, DbPutString.class);
    }

    @Override
    public Request<?, DbGetString> dbGetString(String databaseName, String keyName) {
        return new Request<String, DbGetString>("db_getString", Arrays.asList(databaseName, keyName), this.web3jService, DbGetString.class);
    }

    @Override
    public Request<?, DbPutHex> dbPutHex(String databaseName, String keyName, String dataToStore) {
        return new Request<String, DbPutHex>("db_putHex", Arrays.asList(databaseName, keyName, dataToStore), this.web3jService, DbPutHex.class);
    }

    @Override
    public Request<?, DbGetHex> dbGetHex(String databaseName, String keyName) {
        return new Request<String, DbGetHex>("db_getHex", Arrays.asList(databaseName, keyName), this.web3jService, DbGetHex.class);
    }

    @Override
    public Request<?, com.platon.protocol.core.methods.response.ShhPost> shhPost(ShhPost shhPost) {
        return new Request<ShhPost, com.platon.protocol.core.methods.response.ShhPost>("shh_post", Arrays.asList(shhPost), this.web3jService, com.platon.protocol.core.methods.response.ShhPost.class);
    }

    @Override
    public Request<?, ShhVersion> shhVersion() {
        return new Request("shh_version", Collections.emptyList(), this.web3jService, ShhVersion.class);
    }

    @Override
    public Request<?, ShhNewIdentity> shhNewIdentity() {
        return new Request("shh_newIdentity", Collections.emptyList(), this.web3jService, ShhNewIdentity.class);
    }

    @Override
    public Request<?, ShhHasIdentity> shhHasIdentity(String identityAddress) {
        return new Request<String, ShhHasIdentity>("shh_hasIdentity", Arrays.asList(identityAddress), this.web3jService, ShhHasIdentity.class);
    }

    @Override
    public Request<?, ShhNewGroup> shhNewGroup() {
        return new Request("shh_newGroup", Collections.emptyList(), this.web3jService, ShhNewGroup.class);
    }

    @Override
    public Request<?, ShhAddToGroup> shhAddToGroup(String identityAddress) {
        return new Request<String, ShhAddToGroup>("shh_addToGroup", Arrays.asList(identityAddress), this.web3jService, ShhAddToGroup.class);
    }

    @Override
    public Request<?, ShhNewFilter> shhNewFilter(ShhFilter shhFilter) {
        return new Request<ShhFilter, ShhNewFilter>("shh_newFilter", Arrays.asList(shhFilter), this.web3jService, ShhNewFilter.class);
    }

    @Override
    public Request<?, ShhUninstallFilter> shhUninstallFilter(BigInteger filterId) {
        return new Request<String, ShhUninstallFilter>("shh_uninstallFilter", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, ShhUninstallFilter.class);
    }

    @Override
    public Request<?, ShhMessages> shhGetFilterChanges(BigInteger filterId) {
        return new Request<String, ShhMessages>("shh_getFilterChanges", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, ShhMessages.class);
    }

    @Override
    public Request<?, ShhMessages> shhGetMessages(BigInteger filterId) {
        return new Request<String, ShhMessages>("shh_getMessages", Arrays.asList(Numeric.toHexStringWithPrefixSafe((BigInteger)filterId)), this.web3jService, ShhMessages.class);
    }

    @Override
    public Request<?, TxPoolStatus> txPoolStatus() {
        return new Request("txpool_status", Collections.emptyList(), this.web3jService, TxPoolStatus.class);
    }

    @Override
    public Observable<NewHeadsNotification> newHeadsNotifications() {
        return this.web3jService.subscribe(new Request<String, PlatonSubscribe>("hskchain_subscribe", Collections.singletonList("newHeads"), this.web3jService, PlatonSubscribe.class), "hskchain_unsubscribe", NewHeadsNotification.class);
    }

    @Override
    public Observable<LogNotification> logsNotifications(List<String> addresses, List<String> topics) {
        Map<String, Object> params = this.createLogsParams(addresses, topics);
        return this.web3jService.subscribe(new Request<Object, PlatonSubscribe>("hskchain_subscribe", Arrays.asList("logs", params), this.web3jService, PlatonSubscribe.class), "hskchain_unsubscribe", LogNotification.class);
    }

    private Map<String, Object> createLogsParams(List<String> addresses, List<String> topics) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!addresses.isEmpty()) {
            params.put("address", addresses);
        }
        if (!topics.isEmpty()) {
            params.put("topics", topics);
        }
        return params;
    }

    @Override
    public Observable<String> platonBlockHashObservable() {
        return this.web3jRx.ethBlockHashObservable(this.blockTime);
    }

    @Override
    public Observable<String> platonPendingTransactionHashObservable() {
        return this.web3jRx.ethPendingTransactionHashObservable(this.blockTime);
    }

    @Override
    public Observable<Log> platonLogObservable(PlatonFilter ethFilter) {
        return this.web3jRx.ethLogObservable(ethFilter, this.blockTime);
    }

    @Override
    public Observable<Transaction> transactionObservable() {
        return this.web3jRx.transactionObservable(this.blockTime);
    }

    @Override
    public Observable<Transaction> pendingTransactionObservable() {
        return this.web3jRx.pendingTransactionObservable(this.blockTime);
    }

    @Override
    public Observable<PlatonBlock> blockObservable(boolean fullTransactionObjects) {
        return this.web3jRx.blockObservable(fullTransactionObjects, this.blockTime);
    }

    @Override
    public Observable<PlatonBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Observable<PlatonBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.web3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Observable<Transaction> replayTransactionsObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.web3jRx.replayTransactionsObservable(startBlock, endBlock);
    }

    @Override
    public Observable<PlatonBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<PlatonBlock> onCompleteObservable) {
        return this.web3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, onCompleteObservable);
    }

    @Override
    public Observable<PlatonBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects);
    }

    @Override
    public Observable<Transaction> catchUpToLatestTransactionObservable(DefaultBlockParameter startBlock) {
        return this.web3jRx.catchUpToLatestTransactionObservable(startBlock);
    }

    @Override
    public Observable<PlatonBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, fullTransactionObjects, this.blockTime);
    }

    @Override
    public Observable<Transaction> catchUpToLatestAndSubscribeToNewTransactionsObservable(DefaultBlockParameter startBlock) {
        return this.web3jRx.catchUpToLatestAndSubscribeToNewTransactionsObservable(startBlock, this.blockTime);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        try {
            this.web3jService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close web3j service", e);
        }
    }

    @Override
    public Request<?, PlatonEvidences> platonEvidences() {
        return new Request("hskchain_evidences", Collections.emptyList(), this.web3jService, PlatonEvidences.class);
    }

    @Override
    public Request<?, AdminProgramVersion> getProgramVersion() {
        return new Request("admin_getProgramVersion", Collections.emptyList(), this.web3jService, AdminProgramVersion.class);
    }

    @Override
    public Request<?, AdminSchnorrNIZKProve> getSchnorrNIZKProve() {
        return new Request("admin_getSchnorrNIZKProve", Collections.emptyList(), this.web3jService, AdminSchnorrNIZKProve.class);
    }

    @Override
    public Request<?, DebugEconomicConfig> getEconomicConfig() {
        return new Request("debug_economicConfig", Collections.emptyList(), this.web3jService, DebugEconomicConfig.class);
    }

    @Override
    public Request<?, PlatonChainId> getChainId() {
        return new Request("hskchain_chainId", Collections.emptyList(), this.web3jService, PlatonChainId.class);
    }

    @Override
    public Request<?, DebugWaitSlashingNodeList> getWaitSlashingNodeList() {
        return new Request("debug_getWaitSlashingNodeList", Collections.emptyList(), this.web3jService, DebugWaitSlashingNodeList.class);
    }

    @Override
    public Request<?, PlatonRawTransaction> platonGetRawTransactionByHash(String transactionHash) {
        return new Request<String, PlatonRawTransaction>("hskchain_getRawTransactionByHash", Arrays.asList(transactionHash), this.web3jService, PlatonRawTransaction.class);
    }

    @Override
    public Request<?, PlatonRawTransaction> platonGetRawTransactionByBlockHashAndIndex(String blockHash, String index) {
        return new Request<String, PlatonRawTransaction>("hskchain_getRawTransactionByBlockHashAndIndex", Arrays.asList(blockHash, index), this.web3jService, PlatonRawTransaction.class);
    }

    @Override
    public Request<?, PlatonRawTransaction> platonGetRawTransactionByBlockNumberAndIndex(String blockNumber, String index) {
        return new Request<String, PlatonRawTransaction>("hskchain_getRawTransactionByBlockNumberAndIndex", Arrays.asList(blockNumber, index), this.web3jService, PlatonRawTransaction.class);
    }

    @Override
    public Request<?, PlatonGetAddressHrp> platonGetAddressHrp() {
        return new Request("hskchain_getAddressHrp", Collections.emptyList(), this.web3jService, PlatonGetAddressHrp.class);
    }

    @Override
    public Request<?, PlatonSignTransaction> platonSignTransaction(com.platon.protocol.core.methods.request.Transaction transaction) {
        return new Request<com.platon.protocol.core.methods.request.Transaction, PlatonSignTransaction>("hskchain_signTransaction", Arrays.asList(transaction), this.web3jService, PlatonSignTransaction.class);
    }

    @Override
    public Request<?, BooleanResponse> minerSetGasPrice(String minGasPrice) {
        return new Request<String, BooleanResponse>("miner_setGasPrice", Arrays.asList(minGasPrice), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, AdminPeerEvents> adminPeerEvents() {
        return new Request("admin_peerEvents", Collections.emptyList(), this.web3jService, AdminPeerEvents.class);
    }
}

