/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.core;

import com.platon.protocol.Web3jService;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;

public class Request<S, T extends Response> {
    private static AtomicLong nextId = new AtomicLong(0L);
    private String jsonrpc = "2.0";
    private boolean bech32 = true;
    private String method;
    private List<S> params;
    private long id;
    private Web3jService web3jService;
    private Class<T> responseType;

    public Request() {
    }

    public Request(String method, List<S> params, Web3jService web3jService, Class<T> type) {
        this.method = method;
        this.params = params;
        this.id = nextId.getAndIncrement();
        this.web3jService = web3jService;
        this.responseType = type;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public boolean getBech32() {
        return this.bech32;
    }

    public void setBech32(boolean bech32) {
        this.bech32 = bech32;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<S> getParams() {
        return this.params;
    }

    public void setParams(List<S> params) {
        this.params = params;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public T send() throws IOException {
        return this.web3jService.send(this, this.responseType);
    }

    public CompletableFuture<T> sendAsync() {
        return this.web3jService.sendAsync(this, this.responseType);
    }

    public Observable<T> observable() {
        return new RemoteCall<Response>(this::send).observable();
    }
}

