/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.core.filters;

import com.platon.protocol.Web3j;
import com.platon.protocol.core.Request;
import com.platon.protocol.core.filters.Callback;
import com.platon.protocol.core.filters.Filter;
import com.platon.protocol.core.filters.FilterException;
import com.platon.protocol.core.methods.response.PlatonFilter;
import com.platon.protocol.core.methods.response.PlatonLog;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class PendingTransactionFilter
extends Filter<String> {
    public PendingTransactionFilter(Web3j web3j, Callback<String> callback) {
        super(web3j, callback);
    }

    @Override
    PlatonFilter sendRequest() throws IOException {
        return this.web3j.platonNewPendingTransactionFilter().send();
    }

    @Override
    void process(List<PlatonLog.LogResult> logResults) {
        for (PlatonLog.LogResult logResult : logResults) {
            if (logResult instanceof PlatonLog.Hash) {
                String transactionHash = ((PlatonLog.Hash)logResult).get();
                this.callback.onEvent(transactionHash);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + ", required Hash");
        }
    }

    @Override
    protected Optional<Request<?, PlatonLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

