/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.core.methods.response;

import com.platon.protocol.core.methods.response.Log;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import java.util.List;

public class TransactionReceipt {
    private String transactionHash;
    private String transactionIndex;
    private String blockHash;
    private String blockNumber;
    private String cumulativeGasUsed;
    private String gasUsed;
    private String contractAddress;
    private String root;
    private String status;
    private String from;
    private String to;
    private List<Log> logs;
    private String logsBloom;

    public TransactionReceipt() {
    }

    public TransactionReceipt(String transactionHash, String transactionIndex, String blockHash, String blockNumber, String cumulativeGasUsed, String gasUsed, String contractAddress, String root, String status, String from, String to, List<Log> logs, String logsBloom) {
        this.transactionHash = transactionHash;
        this.transactionIndex = transactionIndex;
        this.blockHash = blockHash;
        this.blockNumber = blockNumber;
        this.cumulativeGasUsed = cumulativeGasUsed;
        this.gasUsed = gasUsed;
        this.contractAddress = contractAddress;
        this.root = root;
        this.status = status;
        this.from = from;
        this.to = to;
        this.logs = logs;
        this.logsBloom = logsBloom;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public BigInteger getTransactionIndex() {
        return Numeric.decodeQuantity((String)this.transactionIndex);
    }

    public String getTransactionIndexRaw() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public BigInteger getBlockNumber() {
        return Numeric.decodeQuantity((String)this.blockNumber);
    }

    public String getBlockNumberRaw() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public BigInteger getCumulativeGasUsed() {
        return Numeric.decodeQuantity((String)this.cumulativeGasUsed);
    }

    public String getCumulativeGasUsedRaw() {
        return this.cumulativeGasUsed;
    }

    public void setCumulativeGasUsed(String cumulativeGasUsed) {
        this.cumulativeGasUsed = cumulativeGasUsed;
    }

    public BigInteger getGasUsed() {
        return Numeric.decodeQuantity((String)this.gasUsed);
    }

    public String getGasUsedRaw() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isStatusOK() {
        if (null == this.status) {
            return true;
        }
        BigInteger statusQuantity = Numeric.decodeQuantity((String)this.status);
        return BigInteger.ONE.equals(statusQuantity);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionReceipt)) {
            return false;
        }
        TransactionReceipt that = (TransactionReceipt)o;
        if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(that.getTransactionHash()) : that.getTransactionHash() != null) {
            return false;
        }
        if (this.transactionIndex != null ? !this.transactionIndex.equals(that.transactionIndex) : that.transactionIndex != null) {
            return false;
        }
        if (this.getBlockHash() != null ? !this.getBlockHash().equals(that.getBlockHash()) : that.getBlockHash() != null) {
            return false;
        }
        if (this.blockNumber != null ? !this.blockNumber.equals(that.blockNumber) : that.blockNumber != null) {
            return false;
        }
        if (this.cumulativeGasUsed != null ? !this.cumulativeGasUsed.equals(that.cumulativeGasUsed) : that.cumulativeGasUsed != null) {
            return false;
        }
        if (this.gasUsed != null ? !this.gasUsed.equals(that.gasUsed) : that.gasUsed != null) {
            return false;
        }
        if (this.getContractAddress() != null ? !this.getContractAddress().equals(that.getContractAddress()) : that.getContractAddress() != null) {
            return false;
        }
        if (this.getRoot() != null ? !this.getRoot().equals(that.getRoot()) : that.getRoot() != null) {
            return false;
        }
        if (this.getStatus() != null ? !this.getStatus().equals(that.getStatus()) : that.getStatus() != null) {
            return false;
        }
        if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
            return false;
        }
        if (this.getTo() != null ? !this.getTo().equals(that.getTo()) : that.getTo() != null) {
            return false;
        }
        if (this.getLogs() != null ? !this.getLogs().equals(that.getLogs()) : that.getLogs() != null) {
            return false;
        }
        return this.getLogsBloom() != null ? this.getLogsBloom().equals(that.getLogsBloom()) : that.getLogsBloom() == null;
    }

    public int hashCode() {
        int result = this.getTransactionHash() != null ? this.getTransactionHash().hashCode() : 0;
        result = 31 * result + (this.transactionIndex != null ? this.transactionIndex.hashCode() : 0);
        result = 31 * result + (this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0);
        result = 31 * result + (this.blockNumber != null ? this.blockNumber.hashCode() : 0);
        result = 31 * result + (this.cumulativeGasUsed != null ? this.cumulativeGasUsed.hashCode() : 0);
        result = 31 * result + (this.gasUsed != null ? this.gasUsed.hashCode() : 0);
        result = 31 * result + (this.getContractAddress() != null ? this.getContractAddress().hashCode() : 0);
        result = 31 * result + (this.getRoot() != null ? this.getRoot().hashCode() : 0);
        result = 31 * result + (this.getStatus() != null ? this.getStatus().hashCode() : 0);
        result = 31 * result + (this.getFrom() != null ? this.getFrom().hashCode() : 0);
        result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
        result = 31 * result + (this.getLogs() != null ? this.getLogs().hashCode() : 0);
        result = 31 * result + (this.getLogsBloom() != null ? this.getLogsBloom().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TransactionReceipt{transactionHash='" + this.transactionHash + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", blockHash='" + this.blockHash + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", cumulativeGasUsed='" + this.cumulativeGasUsed + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", contractAddress='" + this.contractAddress + '\'' + ", root='" + this.root + '\'' + ", status='" + this.status + '\'' + ", from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", logs=" + this.logs + ", logsBloom='" + this.logsBloom + '\'' + '}';
    }
}

