/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.filter;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import java.util.HashSet;
import java.util.Set;

public class SimplePropertyPreFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private int maxLevel = 0;

    public SimplePropertyPreFilter(String ... properties) {
        this((Class<?>)null, properties);
    }

    public SimplePropertyPreFilter(Class<?> clazz, String ... properties) {
        this.clazz = clazz;
        for (String item : properties) {
            if (item == null) continue;
            this.includes.add(item);
        }
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean process(JSONWriter writer, Object source, String name) {
        if (source == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(source)) {
            return false;
        }
        if (this.excludes.contains(name)) {
            return false;
        }
        if (this.maxLevel > 0 && writer.level() > this.maxLevel) {
            return false;
        }
        return this.includes.size() == 0 || this.includes.contains(name);
    }
}

