/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.LazyByteArray;
import com.platon.rlp.wasm.RLPCodec;
import com.platon.rlp.wasm.RLPElement;
import com.platon.rlp.wasm.RLPItem;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class RLPList
implements RLPElement,
List<RLPElement> {
    static byte[] EMPTY_ENCODED_LIST = RLPCodec.encodeElements(new ArrayList<byte[]>());
    private List<RLPElement> elements = new ArrayList<RLPElement>();
    private LazyByteArray encoded;

    public static RLPList of(RLPElement ... elements) {
        return new RLPList(Arrays.asList(elements));
    }

    public static RLPList fromElements(Collection<? extends RLPElement> elements) {
        return new RLPList(new ArrayList<RLPElement>(elements));
    }

    public static RLPList createEmpty() {
        return new RLPList();
    }

    public static RLPList createEmpty(int cap) {
        return new RLPList(new ArrayList<RLPElement>(cap));
    }

    void setEncoded(LazyByteArray encoded) {
        this.encoded = encoded;
    }

    private void setDirty() {
        this.encoded = null;
    }

    private RLPList() {
    }

    RLPList(List<RLPElement> elements) {
        this.elements = elements;
    }

    @Override
    public boolean isRLPList() {
        return true;
    }

    @Override
    public RLPList asRLPList() {
        return this;
    }

    @Override
    public RLPItem asRLPItem() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public byte[] getEncoded() {
        if (this.size() == 0) {
            return EMPTY_ENCODED_LIST;
        }
        if (this.encoded != null) {
            return this.encoded.get();
        }
        this.encoded = new LazyByteArray(RLPCodec.encodeElements(this.stream().map(RLPElement::getEncoded).collect(Collectors.toList())));
        return this.encoded.get();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<RLPElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(RLPElement rlpElement) {
        this.setDirty();
        return this.elements.add(rlpElement);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.elements.remove(o);
        if (removed) {
            this.setDirty();
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends RLPElement> c) {
        if (c.size() > 0) {
            this.setDirty();
        }
        return this.elements.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends RLPElement> c) {
        boolean success = this.elements.addAll(index, c);
        this.setDirty();
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean success = this.elements.removeAll(c);
        if (success) {
            this.setDirty();
        }
        return success;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean success = this.elements.retainAll(c);
        this.setDirty();
        return success;
    }

    @Override
    public void replaceAll(UnaryOperator<RLPElement> operator) {
        this.elements.replaceAll(operator);
        this.setDirty();
    }

    @Override
    public void sort(Comparator<? super RLPElement> c) {
        this.elements.sort(c);
        this.setDirty();
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.setDirty();
    }

    @Override
    public boolean equals(Object o) {
        return this.elements.equals(o);
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public RLPElement get(int index) {
        return this.elements.get(index);
    }

    @Override
    public RLPElement set(int index, RLPElement element) {
        RLPElement ret = this.elements.set(index, element);
        this.setDirty();
        return ret;
    }

    @Override
    public void add(int index, RLPElement element) {
        this.elements.add(index, element);
        this.setDirty();
    }

    @Override
    public RLPElement remove(int index) {
        RLPElement ret = this.elements.remove(index);
        this.setDirty();
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<RLPElement> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<RLPElement> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    public RLPList subList(int fromIndex, int toIndex) {
        return new RLPList(this.elements.subList(fromIndex, toIndex));
    }

    @Override
    public Spliterator<RLPElement> spliterator() {
        return this.elements.spliterator();
    }

    @Override
    public boolean isRLPItem() {
        return false;
    }

    @Override
    public byte[] asBytes() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public byte asByte() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public short asShort() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public long asLong() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public BigInteger asBigInteger() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public String asString() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public boolean asBoolean() {
        throw new RuntimeException("not a rlp item");
    }

    @Override
    public int asInt() {
        throw new RuntimeException("not a rlp item");
    }
}

