/*
 * Decompiled with CFR 0.152.
 */
package com.platon.abi.wasm.datatypes.generated;

import com.platon.rlp.wasm.datatypes.Int128;
import com.platon.rlp.wasm.datatypes.Int16;
import com.platon.rlp.wasm.datatypes.Int32;
import com.platon.rlp.wasm.datatypes.Int64;
import com.platon.rlp.wasm.datatypes.Int8;
import com.platon.rlp.wasm.datatypes.Uint128;
import com.platon.rlp.wasm.datatypes.Uint16;
import com.platon.rlp.wasm.datatypes.Uint32;
import com.platon.rlp.wasm.datatypes.Uint64;
import com.platon.rlp.wasm.datatypes.Uint8;
import java.math.BigInteger;

public final class WasmAbiTypes {
    private WasmAbiTypes() {
    }

    public static Class<?> getType(String type) {
        switch (type) {
            case "address": {
                return String.class;
            }
            case "bool": {
                return Boolean.class;
            }
            case "string": {
                return String.class;
            }
            case "uint8": {
                return Uint8.class;
            }
            case "int8": {
                return Int8.class;
            }
            case "uint16": {
                return Uint16.class;
            }
            case "int16": {
                return Int16.class;
            }
            case "uint32": {
                return Uint32.class;
            }
            case "int32": {
                return Int32.class;
            }
            case "uint64": {
                return Uint64.class;
            }
            case "int64": {
                return Int64.class;
            }
            case "uint128": {
                return Uint128.class;
            }
            case "int128": {
                return Int128.class;
            }
            case "uint160": {
                return BigInteger.class;
            }
            case "uint256": {
                return BigInteger.class;
            }
            case "uint512": {
                return BigInteger.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
        }
        throw new UnsupportedOperationException("Unsupported type encountered: " + type);
    }

    public static Class<?> getRawType(String type, boolean isVector) {
        switch (type) {
            case "address": {
                return String.class;
            }
            case "bool": {
                return Boolean.TYPE;
            }
            case "string": {
                return String.class;
            }
            case "uint8": {
                if (isVector) {
                    return Byte.TYPE;
                }
                return Uint8.class;
            }
            case "int8": {
                return Int8.class;
            }
            case "uint16": {
                return Uint16.class;
            }
            case "int16": {
                return Int16.class;
            }
            case "uint32": {
                return Uint32.class;
            }
            case "int32": {
                return Int32.class;
            }
            case "uint64": {
                return Uint64.class;
            }
            case "int64": {
                return Int64.class;
            }
            case "uint128": {
                return Uint128.class;
            }
            case "int128": {
                return Int128.class;
            }
            case "uint160": {
                return BigInteger.class;
            }
            case "uint256": {
                return BigInteger.class;
            }
            case "uint512": {
                return BigInteger.class;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        throw new UnsupportedOperationException("Unsupported type encountered: " + type);
    }
}

