/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.bech32.Bech32;
import com.platon.crypto.Keys;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.Sign;
import com.platon.crypto.TransactionEncoder;
import com.platon.parameters.NetworkParameters;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import java.security.SignatureException;

public class SignedRawTransaction
extends RawTransaction {
    private static final int CHAIN_ID_INC = 35;
    private static final int LOWER_REAL_V = 27;
    private Sign.SignatureData signatureData;

    public SignedRawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, Sign.SignatureData signatureData) {
        super(nonce, gasPrice, gasLimit, to, value, data);
        this.signatureData = signatureData;
    }

    public Sign.SignatureData getSignatureData() {
        return this.signatureData;
    }

    public String getFrom() throws SignatureException {
        Long chainId = this.getChainId();
        byte[] encodedTransaction = null == chainId ? TransactionEncoder.encode(this) : TransactionEncoder.encode((RawTransaction)this, chainId);
        BigInteger v = Numeric.toBigInt((byte[])this.getSignatureData().getV());
        byte[] r = this.signatureData.getR();
        byte[] s = this.signatureData.getS();
        Sign.SignatureData signatureDataV = new Sign.SignatureData(this.getRealV(v), r, s);
        BigInteger pubKey = Sign.signedMessageToKey(encodedTransaction, signatureDataV);
        return Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)("0x" + Keys.getAddress(pubKey)));
    }

    public void verify(String from) throws SignatureException {
        String actualFrom = this.getFrom();
        if (!actualFrom.equals(from)) {
            throw new SignatureException("from mismatch");
        }
    }

    private byte getRealV(BigInteger bv) {
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return (byte)v;
        }
        int realV = 27;
        int inc = 0;
        if ((int)v % 2 == 0) {
            inc = 1;
        }
        return (byte)(realV + inc);
    }

    public Long getChainId() {
        return this.getChainId(this.getSignatureData().getV());
    }

    public Long getChainId(byte[] inputV) {
        BigInteger bv = Numeric.toBigInt((byte[])inputV);
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return null;
        }
        return (v - 35L) / 2L;
    }
}

