/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.Credentials;
import com.platon.crypto.Hash;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.TransactionEncoder;
import com.platon.utils.Numeric;

public class TransactionUtils {
    public static byte[] generateTransactionHash(RawTransaction rawTransaction, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, credentials);
        return Hash.sha3((byte[])signedMessage);
    }

    public static byte[] generateTransactionHash(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, chainId, credentials);
        return Hash.sha3((byte[])signedMessage);
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, Credentials credentials) {
        return Numeric.toHexString((byte[])TransactionUtils.generateTransactionHash(rawTransaction, credentials));
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        return Numeric.toHexString((byte[])TransactionUtils.generateTransactionHash(rawTransaction, chainId, credentials));
    }
}

