/*
 * Decompiled with CFR 0.152.
 */
package com.platon.abi.solidity;

import com.platon.abi.solidity.PlatOnTypeEncoder;
import com.platon.abi.solidity.datatypes.Type;
import com.platon.abi.solidity.datatypes.Utf8String;
import com.platon.abi.solidity.datatypes.generated.Int64;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import java.math.BigInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PlatOnTypeEncoderTest {
    @Test
    public void testUintEncode() {
        Uint64 zero = new Uint64(BigInteger.ZERO);
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)zero), (Matcher)CoreMatchers.is((Object)"0000000000000000"));
        Uint64 maxLong = new Uint64(BigInteger.valueOf(Long.MAX_VALUE));
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)maxLong), (Matcher)CoreMatchers.is((Object)"7fffffffffffffff"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvalidUintEncode() {
        new Uint64(BigInteger.valueOf(-1L));
    }

    @Test
    public void testIntEncode() {
        Int64 zero = new Int64(BigInteger.ZERO);
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)zero), (Matcher)CoreMatchers.is((Object)"0000000000000000"));
        Int64 maxLong = new Int64(BigInteger.valueOf(Long.MAX_VALUE));
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)maxLong), (Matcher)CoreMatchers.is((Object)"7fffffffffffffff"));
        Int64 minLong = new Int64(BigInteger.valueOf(Long.MIN_VALUE));
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)minLong), (Matcher)CoreMatchers.is((Object)"8000000000000000"));
        Int64 minusOne = new Int64(BigInteger.valueOf(-1L));
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)minusOne), (Matcher)CoreMatchers.is((Object)"ffffffffffffffff"));
    }

    @Test
    public void testUtf8String() {
        Utf8String string = new Utf8String("Hello, world!");
        Assert.assertThat((Object)PlatOnTypeEncoder.encode((Type)string), (Matcher)CoreMatchers.is((Object)"48656c6c6f2c20776f726c6421"));
    }
}

