/*
 * Decompiled with CFR 0.152.
 */
package com.platon.abi.solidity;

import com.platon.abi.solidity.TypeDecoder;
import com.platon.abi.solidity.TypeReference;
import com.platon.abi.solidity.datatypes.Address;
import com.platon.abi.solidity.datatypes.Bool;
import com.platon.abi.solidity.datatypes.DynamicArray;
import com.platon.abi.solidity.datatypes.DynamicBytes;
import com.platon.abi.solidity.datatypes.StaticArray;
import com.platon.abi.solidity.datatypes.Type;
import com.platon.abi.solidity.datatypes.Utf8String;
import com.platon.abi.solidity.datatypes.generated.Bytes1;
import com.platon.abi.solidity.datatypes.generated.Bytes4;
import com.platon.abi.solidity.datatypes.generated.Bytes6;
import com.platon.abi.solidity.datatypes.generated.Int256;
import com.platon.abi.solidity.datatypes.generated.Int64;
import com.platon.abi.solidity.datatypes.generated.StaticArray2;
import com.platon.abi.solidity.datatypes.generated.Uint256;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import java.math.BigInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class TypeDecoderTest {
    @Test
    public void testBoolDecode() {
        Assert.assertThat((Object)TypeDecoder.decodeBool((String)"0000000000000000000000000000000000000000000000000000000000000000", (int)0), (Matcher)CoreMatchers.is((Object)new Bool(false)));
        Assert.assertThat((Object)TypeDecoder.decodeBool((String)"0000000000000000000000000000000000000000000000000000000000000001", (int)0), (Matcher)CoreMatchers.is((Object)new Bool(true)));
    }

    @Test
    public void testBoolDecodeGivenOffset() {
        Assert.assertThat((Object)TypeDecoder.decode((String)"0000000000000000000000000000000000000000000000007fffffffffffffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007fffffffffffffff", (int)64, Bool.class), (Matcher)CoreMatchers.is((Object)new Bool(false)));
        Assert.assertThat((Object)TypeDecoder.decode((String)"0000000000000000000000000000000000000000000000007fffffffffffffff00000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000007fffffffffffffff", (int)64, Bool.class), (Matcher)CoreMatchers.is((Object)new Bool(true)));
    }

    @Test
    public void testUintDecode() {
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"0000000000000000000000000000000000000000000000000000000000000000", Uint64.class), (Matcher)CoreMatchers.is((Object)new Uint64(BigInteger.ZERO)));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"0000000000000000000000000000000000000000000000007fffffffffffffff", Uint64.class), (Matcher)CoreMatchers.is((Object)new Uint64(BigInteger.valueOf(Long.MAX_VALUE))));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", Uint64.class), (Matcher)CoreMatchers.is((Object)new Uint64(new BigInteger("0ffffffffffffffff", 16))));
    }

    @Test
    public void testIntDecode() {
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"0000000000000000000000000000000000000000000000000000000000000000", Int64.class), (Matcher)CoreMatchers.is((Object)new Int64(BigInteger.ZERO)));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"0000000000000000000000000000000000000000000000007fffffffffffffff", Int64.class), (Matcher)CoreMatchers.is((Object)new Int64(BigInteger.valueOf(Long.MAX_VALUE))));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"fffffffffffffffffffffffffffffffffffffffffffffff88000000000000000", Int64.class), (Matcher)CoreMatchers.is((Object)new Int64(BigInteger.valueOf(Long.MIN_VALUE))));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", Int64.class), (Matcher)CoreMatchers.is((Object)new Int64(BigInteger.valueOf(-1L))));
        Assert.assertThat((Object)TypeDecoder.decodeNumeric((String)"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", Int256.class), (Matcher)CoreMatchers.is((Object)new Int256(BigInteger.valueOf(-1L))));
    }

    @Test
    public void testStaticBytes() {
        Bytes6 staticBytes = new Bytes6(new byte[]{0, 1, 2, 3, 4, 5});
        Assert.assertThat((Object)TypeDecoder.decodeBytes((String)"0001020304050000000000000000000000000000000000000000000000000000", Bytes6.class), (Matcher)CoreMatchers.is((Object)staticBytes));
        Bytes1 empty = new Bytes1(new byte[]{0});
        Assert.assertThat((Object)TypeDecoder.decodeBytes((String)"0000000000000000000000000000000000000000000000000000000000000000", Bytes1.class), (Matcher)CoreMatchers.is((Object)empty));
        Bytes4 dave = new Bytes4("dave".getBytes());
        Assert.assertThat((Object)TypeDecoder.decodeBytes((String)"6461766500000000000000000000000000000000000000000000000000000000", Bytes4.class), (Matcher)CoreMatchers.is((Object)dave));
    }

    @Test
    public void testDynamicBytes() {
        DynamicBytes dynamicBytes = new DynamicBytes(new byte[]{0, 1, 2, 3, 4, 5});
        Assert.assertThat((Object)TypeDecoder.decodeDynamicBytes((String)"00000000000000000000000000000000000000000000000000000000000000060001020304050000000000000000000000000000000000000000000000000000", (int)0), (Matcher)CoreMatchers.is((Object)dynamicBytes));
        DynamicBytes empty = new DynamicBytes(new byte[]{0});
        Assert.assertThat((Object)TypeDecoder.decodeDynamicBytes((String)"00000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000", (int)0), (Matcher)CoreMatchers.is((Object)empty));
        DynamicBytes dave = new DynamicBytes("dave".getBytes());
        Assert.assertThat((Object)TypeDecoder.decodeDynamicBytes((String)"00000000000000000000000000000000000000000000000000000000000000046461766500000000000000000000000000000000000000000000000000000000", (int)0), (Matcher)CoreMatchers.is((Object)dave));
        DynamicBytes loremIpsum = new DynamicBytes("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".getBytes());
        Assert.assertThat((Object)TypeDecoder.decodeDynamicBytes((String)"00000000000000000000000000000000000000000000000000000000000001bd4c6f72656d20697073756d20646f6c6f722073697420616d65742c20636f6e73656374657475722061646970697363696e6720656c69742c2073656420646f20656975736d6f642074656d706f7220696e6369646964756e74207574206c61626f726520657420646f6c6f7265206d61676e6120616c697175612e20557420656e696d206164206d696e696d2076656e69616d2c2071756973206e6f737472756420657865726369746174696f6e20756c6c616d636f206c61626f726973206e69736920757420616c697175697020657820656120636f6d6d6f646f20636f6e7365717561742e2044756973206175746520697275726520646f6c6f7220696e20726570726568656e646572697420696e20766f6c7570746174652076656c697420657373652063696c6c756d20646f6c6f726520657520667567696174206e756c6c612070617269617475722e204578636570746575722073696e74206f6363616563617420637570696461746174206e6f6e2070726f6964656e742c2073756e7420696e2063756c706120717569206f666669636961206465736572756e74206d6f6c6c697420616e696d20696420657374206c61626f72756d2e000000", (int)0), (Matcher)CoreMatchers.is((Object)loremIpsum));
    }

    @Test
    public void testAddress() {
        Assert.assertThat((Object)TypeDecoder.decodeAddress((String)"000000000000000000000000be5422d15f39373eb0a97ff8c10fbd0e40e29338"), (Matcher)CoreMatchers.is((Object)new Address("lat1he2z952l8ymnav9f0luvzraapeqw9yec8247zy")));
    }

    @Test
    public void testUtf8String() {
        Assert.assertThat((Object)TypeDecoder.decodeUtf8String((String)"000000000000000000000000000000000000000000000000000000000000000d48656c6c6f2c20776f726c642100000000000000000000000000000000000000", (int)0), (Matcher)CoreMatchers.is((Object)new Utf8String("Hello, world!")));
    }

    @Test
    public void testStaticArray() {
        Assert.assertThat((Object)TypeDecoder.decodeStaticArray((String)"000000000000000000000000000000000000000000000000000000000000000a0000000000000000000000000000000000000000000000007fffffffffffffff", (int)0, (TypeReference)new TypeReference.StaticArrayTypeReference<StaticArray<Uint256>>(2){}, (int)2), (Matcher)CoreMatchers.is((Object)new StaticArray2((Type[])new Uint256[]{new Uint256(BigInteger.TEN), new Uint256(BigInteger.valueOf(Long.MAX_VALUE))})));
        Assert.assertThat((Object)TypeDecoder.decodeStaticArray((String)"000000000000000000000000000000000000000000000000000000000000000d48656c6c6f2c20776f726c642100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d776f726c64212048656c6c6f2c00000000000000000000000000000000000000", (int)0, (TypeReference)new TypeReference.StaticArrayTypeReference<StaticArray<Utf8String>>(2){}, (int)2), (Matcher)IsEqual.equalTo((Object)new StaticArray2((Type[])new Utf8String[]{new Utf8String("Hello, world!"), new Utf8String("world! Hello,")})));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEmptyStaticArray() {
        Assert.assertThat((Object)TypeDecoder.decodeStaticArray((String)"0000000000000000000000000000000000000000000000000000000000000000", (int)0, (TypeReference)new TypeReference.StaticArrayTypeReference<StaticArray<Uint256>>(0){}, (int)0), (Matcher)CoreMatchers.is((Object)"invalid"));
    }

    @Test
    public void testDynamicArray() {
        Assert.assertThat((Object)TypeDecoder.decodeDynamicArray((String)"0000000000000000000000000000000000000000000000000000000000000000", (int)0, (TypeReference)new TypeReference<DynamicArray<Uint256>>(){}), (Matcher)IsEqual.equalTo((Object)DynamicArray.empty((String)"uint256")));
        Assert.assertThat((Object)TypeDecoder.decodeDynamicArray((String)"0000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000a0000000000000000000000000000000000000000000000007fffffffffffffff", (int)0, (TypeReference)new TypeReference<DynamicArray<Uint256>>(){}), (Matcher)IsEqual.equalTo((Object)new DynamicArray((Type[])new Uint256[]{new Uint256(BigInteger.TEN), new Uint256(BigInteger.valueOf(Long.MAX_VALUE))})));
        Assert.assertThat((Object)TypeDecoder.decodeDynamicArray((String)"0000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000d48656c6c6f2c20776f726c642100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d776f726c64212048656c6c6f2c00000000000000000000000000000000000000", (int)0, (TypeReference)new TypeReference<DynamicArray<Utf8String>>(){}), (Matcher)IsEqual.equalTo((Object)new DynamicArray((Type[])new Utf8String[]{new Utf8String("Hello, world!"), new Utf8String("world! Hello,")})));
    }
}

