/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.platon.rlp.datatypes.Pair;
import com.platon.rlp.datatypes.WasmAddress;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.WasmEventEncoder;
import org.web3j.abi.WasmFunctionEncoder;
import org.web3j.abi.datatypes.WasmEvent;
import org.web3j.abi.datatypes.WasmEventParameter;
import org.web3j.abi.datatypes.WasmFunction;
import org.web3j.abi.datatypes.generated.WasmAbiTypes;
import org.web3j.codegen.GenerationReporter;
import org.web3j.codegen.Generator;
import org.web3j.codegen.LogGenerationReporter;
import org.web3j.codegen.WasmFunctionWrapperGenerator;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.PlatonFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.WasmAbiDefinition;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.WasmContract;
import org.web3j.tx.gas.GasProvider;
import org.web3j.utils.Collection;
import org.web3j.utils.Strings;
import org.web3j.utils.Version;
import rx.Observable;
import rx.functions.Func1;

public class WasmFunctionWrapper
extends Generator {
    private static final String BINARY = "BINARY";
    private static final String WEB3J = "web3j";
    private static final String CREDENTIALS = "credentials";
    private static final String CONTRACT_GAS_PROVIDER = "contractGasProvider";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String INITIAL_VALUE = "initialVonValue";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String CHAINID = "chainId";
    private static final String GAS_PRICE = "gasPrice";
    private static final String GAS_LIMIT = "gasLimit";
    private static final String FILTER = "filter";
    private static final String START_BLOCK = "startBlock";
    private static final String END_BLOCK = "endBlock";
    private static final String VON_VALUE = "vonValue";
    private static final String FUNC_NAME_PREFIX = "FUNC_";
    private static final ClassName LOG = ClassName.get(Log.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(WasmFunctionWrapper.class);
    private static final String CODEGEN_WARNING = "<p>Auto generated code.\n<p><strong>Do not modify!</strong>\n<p>Please use the <a href=\"https://github.com/PlatONnetwork/client-sdk-java/releases\">platon-web3j command line tools</a>,\nor the " + WasmFunctionWrapperGenerator.class.getName() + " in the \n" + "<a href=\"https://github.com/PlatONnetwork/client-sdk-java/tree/master/codegen\">" + "codegen module</a> to update.\n";
    private static final String regex = "(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?";
    private static final String regex_map = "(map)(?:\\<(.*?)),(?:(.*?)\\>$)";
    private static final String regex_set = "(set)(?:\\<(.*?)\\>$)";
    private static final String regex_list = "(list)(?:\\<(.*?)\\>$)";
    private static final String regex_pair = "(pair)(?:\\<(.*?)),(?:(.*?)\\>$)";
    private static final String regex_fixedHash = "(FixedHash)(?:\\<(.*?)\\>)(?:\\[(.*?)\\])?";
    private static final Pattern pattern = Pattern.compile("(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?");
    private static final Pattern pattern_map = Pattern.compile("(map)(?:\\<(.*?)),(?:(.*?)\\>$)");
    private static final Pattern pattern_set = Pattern.compile("(set)(?:\\<(.*?)\\>$)");
    private static final Pattern pattern_list = Pattern.compile("(list)(?:\\<(.*?)\\>$)");
    private static final Pattern pattern_pair = Pattern.compile("(pair)(?:\\<(.*?)),(?:(.*?)\\>$)");
    private static final Pattern pattern_fixedHash = Pattern.compile("(FixedHash)(?:\\<(.*?)\\>)(?:\\[(.*?)\\])?");
    private final GenerationReporter reporter;

    public WasmFunctionWrapper() {
        this(new LogGenerationReporter(LOGGER));
    }

    WasmFunctionWrapper(GenerationReporter reporter) {
        this.reporter = reporter;
    }

    public void generateJavaFiles(String contractName, String bin, String abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException {
        this.generateJavaFiles(contractName, bin, this.loadContractDefinition(abi), destinationDir, basePackageName);
    }

    void generateJavaFiles(String contractName, String bin, List<WasmAbiDefinition> abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException {
        String className = Strings.capitaliseFirstLetter((String)contractName);
        TypeSpec.Builder classBuilder = this.createClassBuilder(className, bin);
        classBuilder.addMethod(WasmFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS));
        classBuilder.addMethod(WasmFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER));
        classBuilder.addFields(this.buildFuncNameConstants(abi));
        classBuilder.addMethods(this.buildFunctionDefinitions(className, classBuilder, abi));
        classBuilder.addMethod(WasmFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS));
        classBuilder.addMethod(WasmFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER));
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    private TypeSpec.Builder createClassBuilder(String className, String binary) {
        String javadoc = CODEGEN_WARNING + this.getWeb3jVersion();
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]).superclass(WasmContract.class).addFields(this.createBinaryDefinition(binary));
    }

    private String getWeb3jVersion() {
        String version;
        try {
            version = Version.getVersion();
        }
        catch (IOException | NullPointerException e) {
            version = "none";
        }
        return "\n<p>Generated with platon-web3j version " + version + ".\n";
    }

    private List<FieldSpec> createBinaryDefinition(String binary) {
        int size;
        ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        int len = binary.length();
        int num = len % (size = 65534) == 0 ? len / size : len / size + 1;
        String code = "";
        for (int i = 0; i < num; ++i) {
            String content = binary.substring(i * size, (i + 1) * size > len ? len : (i + 1) * size);
            String name = "BINARY_" + i;
            fieldSpecs.add(FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("$S", new Object[]{content}).build());
            if (i > 0) {
                code = code + " + ";
            }
            code = code + name;
        }
        fieldSpecs.add(FieldSpec.builder(String.class, (String)BINARY, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).initializer("$L", new Object[]{code}).build());
        return fieldSpecs;
    }

    private static MethodSpec buildConstructor(Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(Long.class, CHAINID, new Modifier[0]).addStatement("super($N, $N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        return toReturn.build();
    }

    private Iterable<FieldSpec> buildFuncNameConstants(List<WasmAbiDefinition> functionDefinitions) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("deploy");
        for (WasmAbiDefinition functionDefinition : functionDefinitions) {
            String funcName;
            if (!functionDefinition.getType().equals("Action") || (funcName = functionDefinition.getName()).equals("init") || fieldNames.contains(funcName)) continue;
            FieldSpec field = FieldSpec.builder(String.class, (String)WasmFunctionWrapper.funcNameToConst(funcName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{funcName}).build();
            fields.add(field);
            fieldNames.add(funcName);
        }
        return fields;
    }

    private List<MethodSpec> buildFunctionDefinitions(String className, TypeSpec.Builder classBuilder, List<WasmAbiDefinition> functionDefinitions) throws ClassNotFoundException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        Set<String> customTypes = this.getCustomType(functionDefinitions);
        boolean constructor = false;
        for (WasmAbiDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals("Action")) {
                if (functionDefinition.getName().equals("init")) {
                    constructor = true;
                    methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, true, customTypes, false));
                    methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, true, customTypes, false));
                    methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, true, customTypes, true));
                    methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, true, customTypes, true));
                    continue;
                }
                methodSpecs.add(this.buildFunction(functionDefinition, customTypes, false));
                if (functionDefinition.isConstant()) continue;
                methodSpecs.add(this.buildFunction(functionDefinition, customTypes, true));
                continue;
            }
            if (functionDefinition.getType().equals("Event")) {
                methodSpecs.addAll(this.buildEventFunctions(functionDefinition, classBuilder, customTypes));
                continue;
            }
            if (!functionDefinition.getType().equals("struct")) continue;
            classBuilder.addType(this.buildStruct(functionDefinition, customTypes));
        }
        if (!constructor) {
            MethodSpec.Builder credentialsMethodBuilder = WasmFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, true);
            methodSpecs.add(WasmFunctionWrapper.buildDeployNoParams(credentialsMethodBuilder, className, CREDENTIALS, false, true));
            MethodSpec.Builder transactionManagerMethodBuilder = WasmFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, true);
            methodSpecs.add(WasmFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilder, className, TRANSACTION_MANAGER, false, true));
        }
        return methodSpecs;
    }

    private Set<String> getCustomType(List<WasmAbiDefinition> functionDefinitions) {
        HashSet<String> structs = new HashSet<String>();
        for (WasmAbiDefinition functionDefinition : functionDefinitions) {
            if (!functionDefinition.getType().equals("struct")) continue;
            structs.add(functionDefinition.getName());
        }
        return structs;
    }

    private MethodSpec buildDeploy(String className, WasmAbiDefinition functionDefinition, Class authType, String authName, boolean withGasProvider, Set<String> customTypes, boolean isPayable) {
        MethodSpec.Builder methodBuilder = WasmFunctionWrapper.getDeployMethodSpec(className, authType, authName, isPayable, withGasProvider);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInput(), customTypes);
        if (!inputParams.isEmpty()) {
            return WasmFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName, isPayable, withGasProvider);
        }
        return WasmFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName, isPayable, withGasProvider);
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName, boolean isPayable, boolean withGasProvider) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)WasmFunctionWrapper.buildRemoteCall((TypeName)ClassName.get((String)"", (String)className, (String[])new String[0]))).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
        if (isPayable && !withGasProvider) {
            builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        } else if (isPayable && withGasProvider) {
            builder.addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        } else if (!isPayable && withGasProvider) {
            builder.addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]);
        } else {
            builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]);
        }
        return builder.addParameter(Long.class, CHAINID, new Modifier[0]);
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName, boolean isPayable, boolean withGasPRovider) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($L, $T.asList())", new Object[]{String.class, WasmFunctionEncoder.class, BINARY, Arrays.class});
        if (isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, INITIAL_VALUE, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, INITIAL_VALUE, CHAINID});
        } else if (!isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName, boolean isPayable, boolean withGasProvider) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($L, $T.asList($L))", new Object[]{String.class, WasmFunctionEncoder.class, BINARY, Arrays.class, inputParams});
        if (isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, INITIAL_VALUE, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, INITIAL_VALUE, CHAINID});
        } else if (!isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        }
        return methodBuilder.build();
    }

    public TypeSpec buildStruct(WasmAbiDefinition functionDefinition, Set<String> customTypes) {
        String className = Strings.capitaliseFirstLetter((String)functionDefinition.getName());
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        if (null != functionDefinition.getBaseclass() && !functionDefinition.getBaseclass().isEmpty()) {
            String baseClass = Strings.capitaliseFirstLetter((String)((String)functionDefinition.getBaseclass().get(0)));
            FieldSpec field = FieldSpec.builder((TypeName)ClassName.get((String)"", (String)baseClass, (String[])new String[0]), (String)"baseClass", (Modifier[])new Modifier[]{Modifier.PUBLIC}).build();
            fieldSpecs.add(field);
        }
        for (int i = 0; i < functionDefinition.getFields().size(); ++i) {
            WasmAbiDefinition.NamedType namedType = (WasmAbiDefinition.NamedType)functionDefinition.getFields().get(i);
            String name = namedType.getName();
            String type = namedType.getType();
            fieldSpecs.add(FieldSpec.builder((TypeName)WasmFunctionWrapper.buildTypeName(type, customTypes), (String)name, (Modifier[])new Modifier[]{Modifier.PUBLIC}).build());
        }
        typeBuilder.addFields(fieldSpecs);
        return typeBuilder.build();
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((String)"", (String)className, (String[])new String[0])).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(Long.class, CHAINID, new Modifier[0]).addStatement("return new $L($L, $L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        return toReturn.build();
    }

    String addParameters(MethodSpec.Builder methodBuilder, List<WasmAbiDefinition.NamedType> namedTypes, Set<String> customTypes) {
        List<ParameterSpec> inputParameterTypes = WasmFunctionWrapper.buildParameterTypes(namedTypes, customTypes);
        methodBuilder.addParameters(inputParameterTypes);
        String inputParams = Collection.join(inputParameterTypes, (String)",", parameterSpec -> parameterSpec.name);
        if (inputParameterTypes.size() == 1 && inputParameterTypes.get((int)0).type instanceof ArrayTypeName) {
            inputParams = inputParams + ", Void.class";
        }
        return inputParams;
    }

    static List<ParameterSpec> buildParameterTypes(List<WasmAbiDefinition.NamedType> namedTypes, Set<String> customTypes) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            WasmAbiDefinition.NamedType namedType = namedTypes.get(i);
            String name = WasmFunctionWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            result.add(ParameterSpec.builder((TypeName)WasmFunctionWrapper.buildTypeName(type, customTypes), (String)name, (Modifier[])new Modifier[0]).build());
        }
        return result;
    }

    static String createValidParamName(String name, int idx) {
        if (name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    MethodSpec buildFunction(WasmAbiDefinition functionDefinition, Set<String> customTypes, boolean isPayable) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInput(), customTypes);
        ArrayList<TypeName> outputParameterTypes = new ArrayList<TypeName>();
        if (functionDefinition.hasOutputs()) {
            String type = functionDefinition.getOutput();
            outputParameterTypes.add(WasmFunctionWrapper.buildTypeName(type, customTypes));
        }
        if (functionDefinition.isConstant()) {
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams, customTypes);
        } else {
            this.buildTransactionFunction(functionDefinition, methodBuilder, inputParams, isPayable);
        }
        return methodBuilder.build();
    }

    private void buildConstantFunction(WasmAbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams, Set<String> customTypes) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (outputParameterTypes.isEmpty()) {
            methodBuilder.addStatement("throw new RuntimeException(\"cannot call constant function with void return type\")", new Object[0]);
        } else {
            TypeName typeName = outputParameterTypes.get(0);
            if (typeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
                methodBuilder.returns((TypeName)WasmFunctionWrapper.buildRemoteCall((TypeName)parameterizedTypeName.rawType));
                methodBuilder.addStatement("final $T function = new $T($N, $T.asList($L), $T.class, $L)", new Object[]{WasmFunction.class, WasmFunction.class, WasmFunctionWrapper.funcNameToConst(functionName), Arrays.class, inputParams, parameterizedTypeName.rawType, WasmFunctionWrapper.getParameterizedType(parameterizedTypeName)});
                methodBuilder.addStatement("return executeRemoteCall(function, $T.class)", new Object[]{parameterizedTypeName.rawType});
            } else {
                methodBuilder.returns((TypeName)WasmFunctionWrapper.buildRemoteCall(typeName));
                methodBuilder.addStatement("final $T function = new $T($N, $T.asList($L), $T.class)", new Object[]{WasmFunction.class, WasmFunction.class, WasmFunctionWrapper.funcNameToConst(functionName), Arrays.class, inputParams, typeName});
                methodBuilder.addStatement("return executeRemoteCall(function, $T.class)", new Object[]{typeName});
            }
        }
    }

    private static ParameterizedTypeName buildRemoteCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private void buildTransactionFunction(WasmAbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams, boolean isPayable) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (isPayable) {
            methodBuilder.addParameter(BigInteger.class, VON_VALUE, new Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        methodBuilder.returns((TypeName)WasmFunctionWrapper.buildRemoteCall(TypeName.get(TransactionReceipt.class)));
        methodBuilder.addStatement("final $T function = new $T($N, $T.asList($L), Void.class)", new Object[]{WasmFunction.class, WasmFunction.class, WasmFunctionWrapper.funcNameToConst(functionName), Arrays.class, inputParams});
        if (isPayable) {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N)", new Object[]{VON_VALUE});
        } else {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function)", new Object[0]);
        }
    }

    List<MethodSpec> buildEventFunctions(WasmAbiDefinition functionDefinition, TypeSpec.Builder classBuilder, Set<String> customTypes) {
        String functionName = functionDefinition.getName();
        String responseClassName = Strings.capitaliseFirstLetter((String)functionName) + "EventResponse";
        List inputs = functionDefinition.getInput();
        int topic = functionDefinition.getTopic();
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        for (int i = 0; i < inputs.size(); ++i) {
            WasmAbiDefinition.NamedType namedType = (WasmAbiDefinition.NamedType)inputs.get(i);
            String name = namedType.getName();
            String type = namedType.getType();
            TypeName typeName = WasmFunctionWrapper.buildTypeName(type, customTypes);
            boolean indexed = i < topic;
            NamedTypeName parameter = new NamedTypeName(name, typeName, indexed);
            if (indexed) {
                indexedParameters.add(parameter);
                continue;
            }
            nonIndexedParameters.add(parameter);
        }
        classBuilder.addField(this.createEventDefinition(functionName, indexedParameters, nonIndexedParameters));
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildEventObservableFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildDefaultEventObservableFunction(responseClassName, functionName));
        return methods;
    }

    private FieldSpec createEventDefinition(String name, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        CodeBlock initializer = WasmFunctionWrapper.buildVariableLengthEventInitializer(name, indexedParameters, nonIndexedParameters);
        return FieldSpec.builder(WasmEvent.class, (String)this.buildEventDefinitionName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer).build();
    }

    private static CodeBlock buildVariableLengthEventInitializer(String eventName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(WasmEvent.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        String indexedParamStr = "";
        for (int i = 0; i < indexedParameters.size(); ++i) {
            TypeName typeName;
            if (i > 0) {
                indexedParamStr = indexedParamStr + " , ";
            }
            if ((typeName = indexedParameters.get(i).getTypeName()) instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
                String paramStr = WasmFunctionWrapper.getParameterizedType(parameterizedTypeName);
                indexedParamStr = indexedParamStr + "new $T($T.class, $L, true)";
                objects.add(WasmEventParameter.class);
                objects.add(parameterizedTypeName.rawType);
                objects.add(paramStr);
                continue;
            }
            indexedParamStr = indexedParamStr + "new $T($T.class, true)";
            objects.add(WasmEventParameter.class);
            objects.add(typeName);
        }
        objects.add(Arrays.class);
        String nonIndexedParamStr = "";
        for (int i = 0; i < nonIndexedParameters.size(); ++i) {
            TypeName typeName;
            if (i > 0) {
                nonIndexedParamStr = nonIndexedParamStr + " , ";
            }
            if ((typeName = nonIndexedParameters.get(i).getTypeName()) instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
                String paramStr = WasmFunctionWrapper.getParameterizedType(parameterizedTypeName);
                nonIndexedParamStr = nonIndexedParamStr + "new $T($T.class, $L)";
                objects.add(WasmEventParameter.class);
                objects.add(parameterizedTypeName.rawType);
                objects.add(paramStr);
                continue;
            }
            nonIndexedParamStr = nonIndexedParamStr + "new $T($T.class)";
            objects.add(WasmEventParameter.class);
            objects.add(typeName);
        }
        return CodeBlock.builder().addStatement("new $T($S, $T.asList(" + indexedParamStr + "), $T.asList(" + nonIndexedParamStr + "))", objects.toArray()).build();
    }

    private String buildEventDefinitionName(String eventName) {
        return eventName.toUpperCase() + "_EVENT";
    }

    TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        builder.addField((TypeName)LOG, "log", new Modifier[]{Modifier.PUBLIC});
        for (NamedTypeName namedType : indexedParameters) {
            builder.addField((TypeName)ClassName.get(String.class), namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            builder.addField(namedType.getTypeName(), namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        return builder.build();
    }

    MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + Strings.capitaliseFirstLetter((String)functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]).returns((TypeName)parameterizedTypeName);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", " + "transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{WasmContract.WasmEventValuesWithLog.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{WasmContract.WasmEventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, false)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters, boolean observable) {
        int i;
        CodeBlock.Builder builder = CodeBlock.builder();
        if (observable) {
            builder.addStatement("$L.log = log", new Object[]{objectName});
        } else {
            builder.addStatement("$L.log = eventValues.getLog()", new Object[]{objectName});
        }
        for (i = 0; i < indexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)", new Object[]{objectName, indexedParameters.get(i).getName(), String.class, i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)", new Object[]{objectName, nonIndexedParameters.get(i).getName(), nonIndexedParameters.get(i).getTypeName(), i});
        }
        return builder.build();
    }

    MethodSpec buildEventObservableFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventObservable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder observableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(PlatonFilter.class, FILTER, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        TypeSpec converter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Func1.class), (TypeName[])new TypeName[]{ClassName.get(Log.class), ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Log.class, "log", new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)responseClassName, (String[])new String[0])).addStatement("$T eventValues = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", log)", new Object[]{WasmContract.WasmEventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, true)).addStatement("return typedResponse", new Object[0]).build()).build();
        observableMethodBuilder.addStatement("return web3j.platonLogObservable(filter).map($L)", new Object[]{converter});
        return observableMethodBuilder.build();
    }

    MethodSpec buildDefaultEventObservableFunction(String responseClassName, String functionName) {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventObservable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder observableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(DefaultBlockParameter.class, START_BLOCK, new Modifier[0]).addParameter(DefaultBlockParameter.class, END_BLOCK, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        observableMethodBuilder.addStatement("$1T filter = new $1T($2L, $3L, getContractAddress())", new Object[]{PlatonFilter.class, START_BLOCK, END_BLOCK}).addStatement("filter.addSingleTopic($T.encode(" + this.buildEventDefinitionName(functionName) + "))", new Object[]{WasmEventEncoder.class}).addStatement("return " + generatedFunctionName + "(filter)", new Object[0]);
        return observableMethodBuilder.build();
    }

    public static String getParameterizedType(ParameterizedTypeName parameterizedTypeName) {
        String rawType = parameterizedTypeName.rawType.toString();
        String argsType = WasmFunctionWrapper.getArgsType(parameterizedTypeName);
        return "\nnew com.platon.rlp.ParameterizedTypeImpl(\nnew java.lang.reflect.Type[] {" + argsType + "}, \n" + rawType + ".class" + ", \n" + rawType + ".class)";
    }

    public static String getArgsType(ParameterizedTypeName parameterizedTypeName) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parameterizedTypeName.typeArguments.size(); ++i) {
            TypeName argType = (TypeName)parameterizedTypeName.typeArguments.get(i);
            if (argType instanceof ParameterizedTypeName) {
                builder.append(WasmFunctionWrapper.getParameterizedType((ParameterizedTypeName)argType));
            } else if (argType instanceof ArrayTypeName) {
                builder.append(((ArrayTypeName)argType).toString() + ".class");
            } else {
                builder.append(((ClassName)argType).toString() + ".class");
            }
            if (i >= parameterizedTypeName.typeArguments.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    static TypeName buildTypeName(String type, Set<String> customTypes) {
        Matcher matcherMap = pattern_map.matcher(type);
        if (matcherMap.find()) {
            String mapName = matcherMap.group(1);
            String keyName = matcherMap.group(2);
            String valueName = matcherMap.group(3);
            LOGGER.debug("buildTypeName >>> map >>> mapName:{},keyName:{},value:{}", new Object[]{mapName, keyName, valueName});
            TypeName keyTypeName = WasmFunctionWrapper.buildTypeName(keyName, customTypes);
            TypeName valueTypeName = WasmFunctionWrapper.buildTypeName(valueName, customTypes);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        }
        Matcher matcherSet = pattern_set.matcher(type);
        if (matcherSet.find()) {
            String setName = matcherSet.group(1);
            String parameterizedName = matcherSet.group(2);
            LOGGER.debug("buildTypeName >>> set >>> setName:{},parameterizedName:{}", (Object)setName, (Object)parameterizedName);
            TypeName parameterizedTypeName = WasmFunctionWrapper.buildTypeName(parameterizedName, customTypes);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{parameterizedTypeName});
        }
        Matcher matcherList = pattern_list.matcher(type);
        if (matcherList.find()) {
            String listName = matcherList.group(1);
            String parameterizedName = matcherList.group(2);
            LOGGER.debug("buildTypeName >>> list >>> listName:{},parameterizedName:{}", (Object)listName, (Object)parameterizedName);
            TypeName parameterizedTypeName = WasmFunctionWrapper.buildTypeName(parameterizedName, customTypes);
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{parameterizedTypeName});
        }
        Matcher matcherPair = pattern_pair.matcher(type);
        if (matcherPair.find()) {
            String pairName = matcherPair.group(1);
            String keyName = matcherPair.group(2);
            String valueName = matcherPair.group(3);
            LOGGER.debug("buildTypeName >>> pair >>> pairName:{},keyName:{},value:{}", new Object[]{pairName, keyName, valueName});
            TypeName keyTypeName = WasmFunctionWrapper.buildTypeName(keyName, customTypes);
            TypeName valueTypeName = WasmFunctionWrapper.buildTypeName(valueName, customTypes);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Pair.class), (TypeName[])new TypeName[]{keyTypeName, valueTypeName});
        }
        Matcher matcherFixedHash = pattern_fixedHash.matcher(type);
        if (matcherFixedHash.find()) {
            String name = matcherFixedHash.group(1);
            String size = matcherFixedHash.group(2);
            String arrayLen = matcherFixedHash.group(3);
            LOGGER.debug("buildTypeName >>> FixedHash >>> name:{},size:{},array length:{}", new Object[]{name, size, arrayLen});
            Object typeName = null != size && Integer.parseInt(size) == 20 ? ClassName.get(WasmAddress.class) : ArrayTypeName.of(Byte.TYPE);
            if (arrayLen != null) {
                typeName = ArrayTypeName.of((TypeName)typeName);
            }
            return typeName;
        }
        Matcher matcher = pattern.matcher(type);
        String baseTypeName = matcher.find() ? matcher.group(1) : type;
        if (customTypes.contains(baseTypeName)) {
            matcher = pattern.matcher(type);
            if (matcher.find()) {
                String className = Strings.capitaliseFirstLetter((String)matcher.group(1));
                ClassName baseType = ClassName.get((String)"", (String)className, (String[])new String[0]);
                ArrayTypeName typeName = ArrayTypeName.of((TypeName)baseType);
                String secondArrayDimension = matcher.group(3);
                if (secondArrayDimension != null) {
                    typeName = ArrayTypeName.of((TypeName)typeName);
                }
                return typeName;
            }
            String className = Strings.capitaliseFirstLetter((String)type);
            return ClassName.get((String)"", (String)className, (String[])new String[0]);
        }
        matcher = pattern.matcher(type);
        if (matcher.find()) {
            Class baseType = WasmAbiTypes.getRawType((String)matcher.group(1), (matcher.group(2).length() <= 0 ? 1 : 0) != 0);
            ArrayTypeName typeName = ArrayTypeName.of((Type)baseType);
            String secondArrayDimension = matcher.group(3);
            if (secondArrayDimension != null) {
                typeName = ArrayTypeName.of((TypeName)typeName);
            }
            return typeName;
        }
        Class cls = WasmAbiTypes.getType((String)type);
        return ClassName.get((Class)cls);
    }

    private List<WasmAbiDefinition> loadContractDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        WasmAbiDefinition[] abiDefinition = (WasmAbiDefinition[])objectMapper.readValue(abi, WasmAbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private static String funcNameToConst(String funcName) {
        return FUNC_NAME_PREFIX + funcName.toUpperCase();
    }

    public static class NamedTypeName {
        private final TypeName typeName;
        private final String name;
        private final boolean indexed;

        NamedTypeName(String name, TypeName typeName, boolean indexed) {
            this.name = name;
            this.typeName = typeName;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public boolean isIndexed() {
            return this.indexed;
        }
    }
}

